% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{outlierdummy}
\alias{outlierdummy}
\title{Outlier detection and matrix creation}
\usage{
outlierdummy(object, level = 0.999, type = c("rstandard", "rstudent"), ...)
}
\arguments{
\item{object}{Model estimated using one of the functions of smooth package.}

\item{level}{Confidence level to use. Everything that is outside the constructed
bounds based on that is flagged as outliers.}

\item{type}{Type of residuals to use: either standardised or studentised.}

\item{...}{Other parameters. Not used yet.}
}
\value{
The class "outlierdummy", which contains the list:
\itemize{
\item outliers - the matrix with the dummy variables, flagging outliers;
\item statistic - the value of the statistic for the normalised variable;
\item id - the ids of the outliers (which observations have them);
\item level - the confidence level used in the process;
\item type - the type of the residuals used.
}
}
\description{
Function detects outliers and creates a matrix with dummy variables. Only point
outliers are considered (no level shifts).
}
\details{
The detection is done based on the type of distribution used and confidence level
specified by user.
}
\examples{

# Generate the data with S distribution
xreg <- cbind(rnorm(100,10,3),rnorm(100,50,5))
xreg <- cbind(100+0.5*xreg[,1]-0.75*xreg[,2]+rs(100,0,3),xreg)
colnames(xreg) <- c("y","x1","x2")

# Fit the normal distribution model
ourModel <- alm(y~x1+x2, xreg, distribution="dnorm")

# Detect outliers
xregOutlierDummy <- outlierdummy(ourModel)

}
\seealso{
\link[stats]{influence.measures}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
