% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chol2symm.R
\name{chol2symm}
\alias{chol2symm}
\title{Cholesky Factor to Symmetric Matrix}
\usage{
chol2symm(x)
}
\arguments{
\item{x}{a square, upper triangular matrix representing the Cholesky
factor of a symmetric, positive definite square matrix}
}
\description{
Evaluate \verb{t(x) \\\%*\\\% x} efficiently, where \code{x} is the
(upper-triangular) Cholesky factor of a symmetric, positive definite square
matrix. I.e. it is the inverse of \code{chol}.
}
\examples{
# a symmetric, positive definite square matrix
y <- rWishart(1, 4, diag(3))[, , 1]
y
u <- chol(y)
u
chol2symm(u)
identical(y, chol2symm(u))
identical(chol2symm(u), t(u) \%*\% u)
\dontrun{
u_greta <- cholesky_variable(3)
y_greta <- chol2symm(u)
}
}
