% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_replace_combine.R
\name{extract-replace-combine}
\alias{extract-replace-combine}
\alias{extract}
\alias{replace}
\alias{cbind}
\alias{rbind}
\alias{c}
\alias{rep}
\title{extract, replace and combine greta arrays}
\arguments{
\item{i, j}{indices specifying elements to extract or replace}

\item{value}{a greta array to replace elements}

\item{...}{either further indices specifying elements to extract or replace
(\code{[}), or multiple greta arrays to combine (\code{cbind()}, \code{rbind()} &
\code{c()}), or additional arguments (\code{rep()})}

\item{drop, recursive}{generic arguments that are ignored for greta arrays}
}
\description{
Generic methods to extract and replace elements of greta arrays,
  or to combine greta arrays.
}
\section{Usage}{
 \preformatted{
# extract
x[i]
x[i, j, ..., drop = FALSE]

# replace
x[i] <- value
x[i, j, ...] <- value

# combine
cbind(...)
rbind(...)
c(..., recursive = FALSE)
rep(x, times, ..., recursive = FALSE)

}
}

\examples{
\dontrun{
 x = as_data(matrix(1:12, 3, 4))

 # extract/replace
 x[1:3, ]
 x[, 2:4] <- 1:9

 # combine
 cbind(x[, 2], x[, 1])
 rbind(x[1, ], x[3, ])
 c(x[, 1], x)
 rep(x[, 2], times = 3)
}
}
