% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arima_model.R
\name{arima_model}
\alias{arima_model}
\title{Specify parameters for an ARIMA model}
\usage{
arima_model(
  frequency = 1,
  p = NULL,
  d = NULL,
  q = NULL,
  P = NULL,
  D = NULL,
  Q = NULL,
  constant = NULL,
  phi = NULL,
  theta = NULL,
  Phi = NULL,
  Theta = NULL,
  sigma = NULL
)
}
\arguments{
\item{frequency}{The length of the seasonal period (e.g., 12 for monthly data).}

\item{p}{An integer equal to the non-seasonal autoregressive order}

\item{d}{An integer equal to the non-seasonal order of differencing}

\item{q}{An integer equal to the non-seasonal moving average order}

\item{P}{An integer equal to the seasonal autoregressive order}

\item{D}{An integer equal to the seasonal order of differencing}

\item{Q}{An integer equal to the seasonal moving average order}

\item{constant}{The intercept term}

\item{phi}{A numeric p-vector containing the AR parameters.}

\item{theta}{A numeric p-vector containing the MA parameters.}

\item{Phi}{A numeric p-vector containing the seasonal AR parameters.}

\item{Theta}{A numeric p-vector containing the seasonal MA parameters.}

\item{sigma}{The standard deviation of the noise.}
}
\value{
An `Arima` object as described in the \code{\link[stats]{arima}} function from the stats package.
}
\description{
This function allows the parameters of a Gaussian \eqn{ARIMA(p,d,q)(P,D,Q)[m]}
process to be specified. The output can be used in \code{\link[forecast]{simulate.Arima}()}
and \code{\link{generate.Arima}}.
If any argument is \code{NULL}, the corresponding parameters are randomly selected.
The AR and MA orders p and q are chosen from \{0,1,2,3\}, the seasonal AR and MA
orders P and Q are from \{0,1,2\}, while the order of differencing,
d is in \{0,1,2\}, and the order of seasonal differencing D is in \{0,1\}, with the
restriction that \eqn{d+D \le 2}. If \code{constant} is \code{NULL}, it is set to
0 if \eqn{d+D = 2}, otherwise it is uniformly sampled on (-3,3).
The model orders and the parameters are uniformly sampled. The AR and MA parameters are selected
to give stationary and invertible processes when \eqn{d=D=0}. The noise variance sigma
is uniformly sampled on (1,5). The parameterization is as specified in Hyndman & Athanasopoulos (2021).
}
\examples{
# An AR(2) model with random parameters
model1 <- arima_model(p = 2, d = 0, q = 0)
# An AR(2) model with specific parameters
model2 <- arima_model(p = 2, d = 0, q = 0, phi = c(1.34, -0.64), sigma = 15)
# Seasonal ARIMA model with randomly selected parameters
model3 <- arima_model(frequency = 4)
# Simulate from each model and plot the results
library(forecast)
simulate(model1, 100) \%>\% plot()
simulate(model2, 100) \%>\% plot()
simulate(model3, 100) \%>\% plot()
}
\seealso{
\code{\link[forecast]{simulate.Arima}}
}
\author{
Rob J Hyndman
}
