% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted_values.R
\name{fitted_values}
\alias{fitted_values}
\alias{fitted_values.gam}
\title{Generate fitted values from a estimated GAM}
\usage{
fitted_values(object, ...)

\method{fitted_values}{gam}(
  object,
  data = NULL,
  scale = c("response", "link", "linear predictor"),
  ci_level = 0.95,
  ...
)
}
\arguments{
\item{object}{a fitted model. Currently only models fitted by \code{\link[mgcv:gam]{mgcv::gam()}}
and \code{\link[mgcv:bam]{mgcv::bam()}} are supported.}

\item{...}{arguments passed to \code{\link[mgcv:predict.gam]{mgcv::predict.gam()}}. Note that \code{type},
\code{newdata}, and \code{se.fit} are already used and passed on to
\code{\link[mgcv:predict.gam]{mgcv::predict.gam()}}.}

\item{data}{optional data frame of covariate values for which fitted values
are to be returned.}

\item{scale}{character; what scale should the fitted values be returned on?
\code{"linear predictor"} is a synonym for \code{"link"} if you prefer that
terminology.}

\item{ci_level}{numeric; a value between 0 and 1 indicating the coverage of
the credible interval.}
}
\value{
A tibble (data frame) whose first \emph{m} columns contain either the data
used to fit the model (if \code{data} was \code{NULL}), or the variables supplied to
\code{data}. Four further columns are added:
\itemize{
\item \code{fitted}: the fitted values on the specified scale,
\item \code{se}: the standard error of the fitted values (always on the \emph{link} scale),
\item \code{lower}, \code{upper}: the limits of the credible interval on the fitted values,
on the specified scale.
}
}
\description{
Generate fitted values from a estimated GAM
}
\note{
Regardless of the scale on which the fitted values are returned, the
\code{se} component of the returned object is on the \emph{link} (\emph{linear predictor})
scale, not the response scale.
}
\examples{
load_mgcv()
\dontshow{
op <- options(cli.unicode = FALSE, pillar.sigfig = 6)
}
sim_df <- data_sim("eg1", n = 400, dist = "normal", scale = 2, seed = 2)
m <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = sim_df, method = "REML")
fv <- fitted_values(m)
fv
\dontshow{options(op)}
}
