% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_transformations.R
\name{par2Matrix}
\alias{par2Matrix}
\alias{par2Gamma}
\alias{par2Theta}
\alias{matrix2par}
\title{Create Gamma or Theta from vector}
\usage{
par2Matrix(par, allowMatrix = FALSE, allowNull = FALSE, zeroRowSums = FALSE)

par2Gamma(par, allowMatrix = FALSE, allowNull = FALSE)

par2Theta(par, allowMatrix = FALSE, allowNull = FALSE)

matrix2par(M, allowVector = FALSE, allowNull = FALSE)
}
\arguments{
\item{par}{Numeric vector with \code{d} elements.
Upper triangular part of a Gamma/Theta matrix.}

\item{allowMatrix}{If \code{TRUE} and \code{par} is already a matrix, return it as is.}

\item{allowNull}{If \code{TRUE} and \code{par} is NULL, return NULL.}

\item{zeroRowSums}{If \code{TRUE} the diagonal is set to (-1) times the rowSums.}

\item{M}{Matrix}

\item{allowVector}{If \code{TRUE} and \code{M} is already a vector, return it as is.}
}
\value{
Numeric matrix \dxd. Full Gamma/Theta matrix corresponding to \code{par}.

Upper triangular part of \code{M} (or \code{M} itself/NULL if allowed)
}
\description{
Convert parameter vector \code{par} (upper triangular part of Gamma/Theta matrix)
to full Gamma/Theta, or vice versa.
}
\seealso{
Other parameter matrix transformations:
\code{\link{Gamma2Sigma}()},
\code{\link{Gamma2graph}()},
\code{\link{chi2Gamma}()}
}
\concept{matrixTransformations}
\keyword{internal}
