% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation_param.R
\name{emp_chi_multdim}
\alias{emp_chi_multdim}
\title{Empirical estimation of extremal correlation \eChi}
\usage{
emp_chi_multdim(data, p = NULL)
}
\arguments{
\item{data}{Numeric \nxd matrix, where \code{n} is the
number of observations and \code{d} is the dimension.}

\item{p}{Numeric scalar between 0 and 1 or \code{NULL}. If \code{NULL} (default),
it is assumed that the \code{data} are already on multivariate Pareto scale. Else,
\code{p} is used as the probability in \code{\link[=data2mpareto]{data2mpareto()}} to standardize the \code{data}.}
}
\value{
Numeric scalar. The empirical \code{d}-dimensional extremal correlation coefficient \eChi
for the \code{data}.
}
\description{
Estimates the \code{d}-dimensional extremal correlation coefficient \eChi empirically.
}
\examples{
n <- 100
d <- 2
p <- .8
G <- cbind(
  c(0, 1.5),
  c(1.5, 0)
)

set.seed(123)
my_data <- rmstable(n, "HR", d = d, par = G)
emp_chi_multdim(my_data, p)
}
