% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{patch_areas}
\alias{patch_areas}
\title{Extract patch areas from a categorical raster}
\usage{
patch_areas(raster, class, edge_size = 0, neighborhood = 8, surf_min = 0)
}
\arguments{
\item{raster}{A RasterLayer object corresponding to a categorical raster layer}

\item{class}{An integer value or vector with the value(s) corresponding to
the code values of the raster layer within which points will be sampled.
are computed.}

\item{edge_size}{An integer value indicating the width of the edge
(in meters) of the raster layer which is ignored during the sampling
(default = 0). It prevents from sampling in the margins of the study area.}

\item{neighborhood}{An integer value indicating which cells are considered
adjacent when contiguous patches are delineated (it should be 8
(default, Queen's case) or 4 (Rook's case)). This parameter is ignored
when \code{by_patch = FALSE}.}

\item{surf_min}{An integer value indicating the minimum surface of a patch
considered for the sampling in number of raster cells. This parameter is used
whatever the \code{by_patch} argument is. Default is 0.}
}
\value{
A data.frame with the areas of the patches
}
\description{
The function extracts patch areas from a categorical raster
}
\author{
P. Savary
}
\keyword{internal}
