% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphab_project_desc.R
\name{graphab_project_desc}
\alias{graphab_project_desc}
\title{Describe the objects of a Graphab project}
\usage{
graphab_project_desc(
  proj_name,
  mode = "patches",
  linkset = NULL,
  proj_path = NULL,
  fig = FALSE
)
}
\arguments{
\item{proj_name}{A character string indicating the Graphab project name.
The project name is also the name of the project directory in which the
file proj_name.xml is.}

\item{mode}{A character string indicating the objects of the project that
are described. It must be either:\itemize{
\item{\code{mode='patches'}(default): The habitat patches are described
with synthetic descriptors (code, number, mean capacity, median capacity,
capacity harmonic mean, capacity Gini coefficient) and a histogram of
capacity distribution.}
\item{\code{mode='linkset'}: The links of a link set are described
with synthetic descriptors (codes, costs, number, mean cost distance,
median cost distance, cost distance harmonic mean, cost distance Gini
coefficient) and a histogram of cost distance distribution.}
\item{\code{mode='both'}: Both the patches and links of a linkset are
described}
}}

\item{linkset}{A character string indicating the name of the link set
whose properties are imported. The link set has been created with Graphab
or using \code{\link{graphab_link}} function.}

\item{proj_path}{(optional) A character string indicating the path to the
directory that contains the project directory. It should be used when the
project directory is not in the current working directory. Default is NULL.
When 'proj_path = NULL', the project directory is equal to \code{getwd()}.}

\item{fig}{Logical (default = FALSE) indicating whether to plot a figure of
the resulting spatial graph. The figure is plotted using function
\code{\link{plot_graph_lg}}. The plotting can be long if the graph has many
nodes and links.}
}
\description{
The function describes the objects of a Graphab project
}
\examples{
\dontrun{
graphab_project_desc(proj_name = "grphb_ex",
                     mode = "patches",
                     fig = FALSE)
}
}
\author{
P. Savary
}
