% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{DesignSemantics}
\alias{DesignSemantics}
\title{Build the design semantics list}
\usage{
DesignSemantics(...)
}
\arguments{
\item{...}{named parameter list of functions (see details)}
}
\value{
a named list; the names should correspond to column names in the \link{Coldata} table,
and the values are functions to add semantics to this table
}
\description{
This is used to add additional columns to the \code{\link{Coldata}} table by giving additional semantics to existing columns.
}
\details{
DesignSemantics returns a list of functions that is supposed to be used as \code{semantics} parameter when calling \code{\link{MakeColdata}}.
For each design vector element matching a name of this list the corresponding function is called by \link{MakeColdata} to add additional columns.

Each function takes two parameters, the first being the original column in the \code{Coldata} table column, the second being its name.

Semantics.time is such a predefined function: Contents such as 3h or 30min are converted into a numerical value (in hours), and no4sU is converted into 0.

By default, this is used for the names duration.4sU and Experimental.time
}
\examples{

Semantics.time(c("5h","30min","no4sU"),"Test")


myfun <- function(s,name) {
        r<-Semantics.time(s,name)
        cbind(r,data.frame(hpi=paste0(r$duration.4sU+3,"h")))
}
sars <- ReadGRAND(system.file("extdata", "sars.tsv.gz", package = "grandR"),
                  design=function(names)
                    MakeColdata(names,c("Cell",Design$dur.4sU,Design$Replicate),
                  semantics=DesignSemantics(duration.4sU=myfun)),
                  verbose=TRUE)
Coldata(sars)

}
\seealso{
\link{MakeColdata}
}
\concept{load}
