% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dotbar_sd.R
\name{plot_dotbar_sd}
\alias{plot_dotbar_sd}
\title{Plot a dotplot on a bar graph with SD error bars with two variables.}
\usage{
plot_dotbar_sd(
  data,
  xcol,
  ycol,
  dotsize = 1.5,
  dotthick = 1,
  bwid = 0.7,
  ewid = 0.2,
  b_alpha = 1,
  d_alpha = 1,
  ColPal = c("okabe_ito", "all_grafify", "bright", "contrast", "dark", "fishy",
    "kelly", "light", "muted", "pale", "r4", "safe", "vibrant"),
  ColRev = FALSE,
  ColSeq = TRUE,
  SingleColour = "NULL",
  TextXAngle = 0,
  fontsize = 20,
  ...
)
}
\arguments{
\item{data}{a data table object, e.g. data.frame or tibble.}

\item{xcol}{name of the column to plot on X axis. This should be a categorical variable.}

\item{ycol}{name of the column to plot on quantitative Y axis. This should be a quantitative variable.}

\item{dotsize}{size of dots relative to binwidth used by \code{\link[ggplot2]{geom_dotplot}}. Default set to 1.5, increase/decrease as needed.}

\item{dotthick}{thickness of dot border (\code{stroke} parameter of \code{geom_dotplot}), default set to 1.}

\item{bwid}{width of bars, default set to 0.7}

\item{ewid}{width of error bars, default set to 0.2.}

\item{b_alpha}{fractional opacity of bars, default set to 1 (i.e. maximum opacity & zero transparency).}

\item{d_alpha}{fractional opacity of dots, default set to 1 (i.e. maximum opacity & zero transparency).}

\item{ColPal}{grafify colour palette to apply, default "okabe_ito"; see \code{\link{graf_palettes}} for available palettes.}

\item{ColRev}{whether to reverse order of colour within the selected palette, default F (FALSE); can be set to T (TRUE).}

\item{ColSeq}{logical TRUE or FALSE. Default TRUE for sequential colours from chosen palette. Set to FALSE for distant colours, which will be applied using  \code{scale_fill_grafify2}.}

\item{SingleColour}{a colour hexcode (starting with #), a number between 1-154, or names of colours from \code{grafify} colour palettes to fill along X-axis aesthetic. Accepts any colour other than "black"; use \code{grey_lin11}, which is almost black.}

\item{TextXAngle}{orientation of text on X-axis; default 0 degrees. Change to 45 or 90 to remove overlapping text.}

\item{fontsize}{parameter of \code{base_size} of fonts in \code{theme_classic}, default set to size 20.}

\item{...}{any additional arguments to pass to \code{ggplot2}\link{geom_dotplot}.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
This function takes a data table, X and Y variables, and plots a graph with a dotplot and bars using \code{\link[ggplot2]{stat_summary}} with \code{geom = "bar"}, and \code{\link[ggplot2]{geom_dotplot}} geometries. Standard deviation (SD) is plotted through \code{\link[ggplot2]{stat_summary}} calculated using \code{mean_sdl} from the \code{ggplot2} package (get help with \code{?mean_sdl}), and 1x SD is plotted (\code{fun.arg = list(mult = 1)}.
}
\details{
The X variable is mapped to the \code{fill} aesthetic in both bar and dotplot.

Colours can be changed using \code{ColPal}, \code{ColRev} or \code{ColSeq} arguments. Colours available can be seen quickly with \code{\link{plot_grafify_palette}}.
\code{ColPal} can be one of the following: "okabe_ito", "dark", "light", "bright", "pale", "vibrant,  "muted" or "contrast".
\code{ColRev} (logical TRUE/FALSE) decides whether colours are chosen from first-to-last or last-to-first from within the chosen palette.
\code{ColSeq} decides whether colours are picked by respecting the order in the palette or the most distant ones using \code{\link[grDevices]{colorRampPalette}}.

If there are many groups along the X axis and you prefer a single colour for the graph,use the \code{SingleColour} argument.

The size of dots can be adjusted using the parameter, which is  \code{dotsize = 1} by default.

This function is related to \code{\link{plot_dotbar_sd}} and \code{\link{plot_dotviolin}}.
}
\examples{
plot_dotbar_sd(data = data_cholesterol, 
xcol = Treatment,
ycol = Cholesterol)

plot_dotbar_sd(data = data_1w_death, 
xcol = Genotype, ycol = Death, 
ColPal = "pale", ColSeq = FALSE, ColRev = TRUE)

#single colour along X
plot_dotbar_sd(data = data_1w_death, 
xcol = Genotype, ycol = Death, 
SingleColour = "light_orange")
}
