% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_3d_scatterbox.R
\name{plot_3d_scatterbox}
\alias{plot_3d_scatterbox}
\title{Plot a scatter and box plot with matched symbols.}
\usage{
plot_3d_scatterbox(
  data,
  xcol,
  ycol,
  shapes,
  symsize = 2.5,
  symthick = 1,
  jitter = 0.2,
  fontsize = 20,
  b_alpha = 1,
  s_alpha = 1,
  ColSeq = TRUE,
  ColPal = c("okabe_ito", "all_grafify", "bright", "contrast", "dark", "fishy",
    "kelly", "light", "muted", "pale", "r4", "safe", "vibrant"),
  ColRev = FALSE,
  SingleColour = "NULL",
  TextXAngle = 0,
  ...
)
}
\arguments{
\item{data}{a data table, e.g. data.frame or tibble.}

\item{xcol}{name of the column with the categorical factor to be plotted on X axis. If your table has numeric X, enter \code{xcol = factor(name of colum)}.}

\item{ycol}{name of the column with quantitative variable to plot on the Y axis.}

\item{shapes}{name of the column with the second categorical factor in a two-way ANOVA design.}

\item{symsize}{size of symbols, default set to 3.}

\item{symthick}{size of outline of symbol lines (\code{stroke = 1.0}), default set to 1.0.}

\item{jitter}{extent of jitter (scatter) of symbols, default is 0.2. Increase to reduce symbol overlap, set to 0 for aligned symbols.}

\item{fontsize}{parameter of \code{base_size} of fonts in \code{theme_classic}, default set to size 20.}

\item{b_alpha}{fractional opacity of boxes, default set to 1 (i.e. maximum opacity & zero transparency).}

\item{s_alpha}{fractional opacity of symbols, default set to 1 (i.e. maximum opacity & zero transparency).}

\item{ColSeq}{logical TRUE or FALSE. Default TRUE for sequential colours from chosen palette. Set to FALSE for distant colours, which will be applied using  \code{scale_fill_grafify2}.}

\item{ColPal}{grafify colour palette to apply, default "okabe_ito"; see \code{\link{graf_palettes}} for available palettes.}

\item{ColRev}{whether to reverse order of colour within the selected palette, default F (FALSE); can be set to T (TRUE).}

\item{SingleColour}{a colour hexcode (starting with #), a number between 1-154, or names of colours from \code{grafify} colour palettes to fill along X-axis aesthetic. Accepts any colour other than "black"; use \code{grey_lin11}, which is almost black.}

\item{TextXAngle}{orientation of text on X-axis; default 0 degrees. Change to 45 or 90 to remove overlapping text.}

\item{...}{any additional arguments to pass to \code{ggplot2}\link{geom_boxplot}.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
The functions \code{\link{plot_3d_scatterbar}}, \code{\link{plot_3d_scatterbox}}, \code{\link{plot_4d_scatterbar}}  and \code{\link{plot_4d_scatterbox}} are useful for plotting one-way or two-way ANOVA designs with randomised blocks or repeated measures. The blocks or subjects can be mapped to the \code{shapes} argument in both functions (up to 25 levels can be mapped to \code{shapes}; there will be an error if this number is exceeded). The 3d versions use the categorical variable (\code{xcol}) for grouping (e.g. one-way ANOVA designs), and 4d versions take an additional grouping variable (e.g. two-way ANOVA designs) that is passed to either \code{boxes} or \code{bars} argument.
}
\details{
These functions rely on \code{\link[ggplot2]{ggplot}} with \code{\link[ggplot2]{geom_point}} and \code{\link[ggplot2]{geom_bar}} (through \code{stat_summary}) or \code{\link[ggplot2]{geom_boxplot}} geometries.

Variables other than the quantitative variable (\code{ycol}) will be automatically converted to categorical variables even if they are numeric in the data table.

Shapes are always plotted in black colour, and their opacity can be changed with the \code{s_alpha} argument and overlap can be reduced with the \code{jitter} argument. Other arguments are similar to other plot functions as briefly explained below.

Bars depict means using \code{\link[ggplot2]{stat_summary}} with \code{geom = "bar", fun = "mean"} , and bar width is set to 0.7 (cannot be changed). Error bar width can be changed with the \code{ewid} argument.

Boxplot geometry uses \code{\link[ggplot2]{geom_boxplot}} with \code{position = position_dodge(width = 0.9), width = 0.6}. The thick line within the boxplot depicts the median, the box the IQR (interquantile range) and the whiskers show 1.5*IQR.

In 4d versions, the two grouping variables (i.e. \code{xcol} and either \code{boxes} or \code{bars}) are passed to ggplot aesthetics through \code{group = interaction{ xcol, shapes}}.

Colours can be changed using \code{ColPal}, \code{ColRev} or \code{ColSeq} arguments.
\code{ColPal} can be one of the following: "okabe_ito", "dark", "light", "bright", "pale", "vibrant,  "muted" or "contrast".
\code{ColRev} (logical TRUE/FALSE) decides whether colours are chosen from first-to-last or last-to-first from within the chosen palette.
\code{ColSeq} (logical TRUE/FALSE) decides whether colours are picked by respecting the order in the palette or the most distant ones using \code{\link[grDevices]{colorRampPalette}}.

All four functions can be expanded further, for example with \code{\link[ggplot2]{facet_grid}} or \code{\link[ggplot2]{facet_wrap}}.
}
\examples{
#3d version for 1-way data with blocking
plot_3d_scatterbox(data = data_1w_death, 
xcol = Genotype, ycol = Death, 
shapes = Experiment)
#compare above graph to
plot_scatterbox(data = data_1w_death, 
xcol = Genotype, ycol = Death)
#single colour graph
plot_3d_scatterbox(data = data_1w_death, 
xcol = Genotype, ycol = Death,
shapes = Experiment,
SingleColour = "pale_grey")

#4d version for 2-way data with blocking
plot_4d_scatterbox(data = data_2w_Tdeath, 
xcol = Genotype, 
ycol = PI, 
boxes = Time, 
shapes = Experiment)

plot_4d_scatterbar(data = data_2w_Festing, 
xcol = Strain, 
ycol = GST, 
bars = Treatment, 
shapes = Block)

}
