% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_model.R
\name{simple_model}
\alias{simple_model}
\title{Model from a linear model fit to data.}
\usage{
simple_model(data, Y_value, Fixed_Factor, ...)
}
\arguments{
\item{data}{a data table object, e.g. data.frame or tibble.}

\item{Y_value}{name of column containing quantitative (dependent) variable, provided within "quotes".}

\item{Fixed_Factor}{name(s) of categorical fixed factors (independent variables) provided as a vector if more than one or within "quotes".}

\item{...}{any additional arguments to pass on to \code{\link{lm}} if required.}
}
\value{
This function returns an object of class "lm".
}
\description{
This function uses \code{\link{lm}} to fit a linear model to data and outputs the model object. It requires a data table, one quantitative dependent variable and one or more independent variables.
The model output can be used to extract coefficients and other information, including post-hoc comparisons. If your experiment design has random factors, use the related function \code{\link{mixed_model}}.
}
\details{
This function is related to \code{link{simple_anova}}.
Output of this function can be used with \code{\link{posthoc_Pairwise}}, \code{\link{posthoc_Levelwise}} and \code{\link{posthoc_vsRef}}, or with \code{\link[emmeans]{emmeans}}.
}
\examples{
#fixed factors provided as a vector
Doubmodel <- simple_model(data = data_doubling_time,
Y_value =  "Doubling_time", 
Fixed_Factor = "Student")
#get summary
summary(Doubmodel)
}
