% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dotbar_sd_sc.R
\name{plot_dotbar_sd_sc}
\alias{plot_dotbar_sd_sc}
\title{Plot a dotplot on a bar graph with SD error bars with two variables.}
\usage{
plot_dotbar_sd_sc(
  data,
  xcol,
  ycol,
  colour = "ok_orange",
  dotsize = 1.5,
  dotthick = 1,
  bwid = 0.7,
  ewid = 0.2,
  b_alpha = 1,
  d_alpha = 1,
  TextXAngle = 0,
  fontsize = 20,
  ...
)
}
\arguments{
\item{data}{a data table object, e.g. data.frame or tibble.}

\item{xcol}{name of the column to plot on X axis. This should be a categorical variable.}

\item{ycol}{name of the column to plot on quantitative Y axis. This should be a quantitative variable.}

\item{colour}{colour of boxes and dots; a number between 1-64, any hexcode or names from \code{grafify} colour palettes. Default is \code{ok_orange}.}

\item{dotsize}{size of dots relative to binwidth used by \code{\link[ggplot2]{geom_dotplot}}. Default set to 1.5, increase/decrease as needed.}

\item{dotthick}{thickness of dot border (\code{stroke} parameter of \code{geom_dotplot}), default set to 1.}

\item{bwid}{width of bars, default set to 0.7}

\item{ewid}{width of error bars, default set to 0.2.}

\item{b_alpha}{fractional opacity of bars, default set to 1 (i.e. maximum opacity & zero transparency).}

\item{d_alpha}{fractional opacity of dots, default set to 1 (i.e. maximum opacity & zero transparency).}

\item{TextXAngle}{orientation of text on X-axis; default 0 degrees. Change to 45 or 90 to remove overlapping text.}

\item{fontsize}{parameter of \code{base_size} of fonts in \code{theme_classic}, default set to size 20.}

\item{...}{any additional arguments to pass to \code{ggplot2}\link{geom_dotplot}.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
This function is related to \code{plot_dotbar_sd}, but this one maps a single or same colour, therefore \verb{_sc}. The only new argument is \code{colour}, which can be any hexcode or name of colours in the \code{all_grafify} \href{https://grafify-vignettes.netlify.app/colour_palettes.html#full-list-of-hexcodes}{palette}.
}
\details{
The default colour is \code{ok_orange}. \code{ColPal} and \code{ColRev} arguments are not available. Colours available can be seen quickly with \code{\link{plot_grafify_palette}}.
}
\examples{
#default "okabe_ito" colour
plot_dotbar_sd_sc(data = data_doubling_time, 
xcol = Student, ycol = Doubling_time)

#a different colour
plot_dotbar_sd_sc(data = data_doubling_time, 
xcol = Student, ycol = Doubling_time, 
colour = "#88ccee")
}
