% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradDescentR.SupportFunctions.R
\name{prediction}
\alias{prediction}
\title{Predicting Function for Linear Model}
\usage{
prediction(model, dataTestInput)
}
\arguments{
\item{model}{a matrix of coefficients used as a linear model to predict 
testing data input. This parameter exclusively produced by the  
gradient-descent-based learning function.}

\item{dataTestInput}{a data.frame represented dataset with input variables 
only (\eqn{m \times n-1}), where \eqn{m} is the number of instances 
and \eqn{n} is the number of input variables only.}
}
\value{
a data.frame of testing data input variables and prediction variables.
}
\description{
A function to predict testing data with built gradient descent model
}
\details{
This function used to predict testing data with only input variable named
\code{dataTestInput}. The \code{model} parameter is the coefficients
that produced by gradient-descent-based learning function. The result of
this function is a dataset that contains \code{dataTestInput} combined 
with prediction data as the last column of dataset.
}
\examples{
 
################################## 
## Predict Testing Data Using GD Model
## load R Package data  
data(gradDescentRData)
## get z-factor Data
dataSet <- gradDescentRData$CompressilbilityFactor
## do variance scaling to dataset
featureScalingResult <- varianceScaling(dataSet)
## split dataset
splitedDataSet <- splitData(featureScalingResult$scaledDataSet)
## built model using GD
model <- GD(splitedDataSet$dataTrain)
## separate testing data with input only
dataTestInput <- (splitedDataSet$dataTest)[,1:ncol(splitedDataSet$dataTest)-1]
## predict testing data using GD model
prediction <- prediction(model,dataTestInput)
## show result()
prediction
    
        
}
\seealso{
\code{\link{GD}}, \code{\link{MBGD}}, \code{\link{SGD}}, \code{\link{SAGD}},         
         \code{\link{MGD}}, \code{\link{AGD}}, \code{\link{ADAGRAD}}, \code{\link{ADADELTA}}        
         \code{\link{RMSPROP}}, \code{\link{ADAM}}
}
