% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm.R
\docType{methods}
\name{norm,vclMatrix,character-method}
\alias{norm,vclMatrix,character-method}
\alias{norm,vclMatrix,missing-method}
\alias{norm,gpuMatrix,character-method}
\alias{norm,gpuMatrix,missing-method}
\alias{norm,ANY,missing-method}
\alias{norm,ANY,character-method}
\title{Compute the Norm of a Matrix}
\usage{
\S4method{norm}{vclMatrix,character}(x, type)

\S4method{norm}{vclMatrix,missing}(x, type)

\S4method{norm}{gpuMatrix,character}(x, type)

\S4method{norm}{gpuMatrix,missing}(x, type)

\S4method{norm}{ANY,missing}(x, type)

\S4method{norm}{ANY,character}(x, type)
}
\arguments{
\item{x}{A gpuR matrix object}

\item{type}{character string, specifying the type of matrix norm to be computed.}
}
\value{
The matrix norm, a non-negative number
}
\description{
Computes a matrix norm of x. The norm can be the one \("O"\) norm, 
the infinity \("I"\) norm, the Frobenius \("F"\) norm, the maximum modulus \("M"\) 
among elements of a matrix, or the “spectral” or "2"-norm, as determined by 
the value of type.
}
\seealso{
\link[base]{norm}
}
\author{
Charles Determan Jr.
}
