% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{covf}
\alias{covf}
\title{Covariance Function}
\usage{
covf(gpModel)
}
\arguments{
\item{gpModel}{object of class GPPM.}
}
\value{
The covariance function as a character string.
}
\description{
Extracts the covariance function from a GPPM.
}
\examples{
\donttest{
data("demoLGCM")
lgcm <- gppm('muI+muS*t','varI+covIS*(t+t#)+varS*t*t#+(t==t#)*sigma',
        demoLGCM,'ID','y')
myCov <- covf(lgcm)
}
}
\seealso{
Other functions to extract from a GPPM: \code{\link{SE}},
  \code{\link{coef.GPPM}}, \code{\link{confint.GPPM}},
  \code{\link{datas}}, \code{\link{fitted.GPPM}},
  \code{\link{getIntern}}, \code{\link{logLik.GPPM}},
  \code{\link{maxnObs}}, \code{\link{meanf}},
  \code{\link{nObs}}, \code{\link{nPars}},
  \code{\link{nPers}}, \code{\link{nPreds}},
  \code{\link{parEsts}}, \code{\link{pars}},
  \code{\link{preds}}, \code{\link{vcov.GPPM}}
}
