% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpb.Dataset.R
\name{dimnames.gpb.Dataset}
\alias{dimnames.gpb.Dataset}
\alias{dimnames<-.gpb.Dataset}
\title{Handling of column names of \code{gpb.Dataset}}
\usage{
\method{dimnames}{gpb.Dataset}(x)

\method{dimnames}{gpb.Dataset}(x) <- value
}
\arguments{
\item{x}{object of class \code{gpb.Dataset}}

\item{value}{a list of two elements: the first one is ignored
and the second one is column names}
}
\value{
A list with the dimension names of the dataset

A list with the dimension names of the dataset
}
\description{
Only column names are supported for \code{gpb.Dataset}, thus setting of
             row names would have no effect and returned row names would be NULL.
}
\details{
Generic \code{dimnames} methods are used by \code{colnames}.
Since row names are irrelevant, it is recommended to use \code{colnames} directly.
}
\examples{
\donttest{
data(agaricus.train, package = "gpboost")
train <- agaricus.train
dtrain <- gpb.Dataset(train$data, label = train$label)
gpb.Dataset.construct(dtrain)
dimnames(dtrain)
colnames(dtrain)
colnames(dtrain) <- make.names(seq_len(ncol(train$data)))
print(dtrain, verbose = TRUE)
}
}
