% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_map_layers.R
\name{add_rectangles}
\alias{add_rectangles}
\title{Add Rectangles}
\usage{
add_rectangles(map, data = get_map_data(map), north, east, south, west,
  id = NULL, draggable = NULL, editable = NULL, stroke_colour = NULL,
  stroke_opacity = NULL, stroke_weight = NULL, fill_colour = NULL,
  fill_opacity = NULL, mouse_over = NULL, mouse_over_group = NULL,
  info_window = NULL, layer_id = NULL, z_index = NULL, digits = 4)
}
\arguments{
\item{map}{a googleway map object created from \code{google_map()}}

\item{data}{data frame containing the bounds for the rectangles}

\item{north}{String specifying the column of \code{data} that contains the
northern most latitude coordinate}

\item{east}{String specifying the column of \code{data} that contains the
eastern most longitude}

\item{south}{String specifying the column of \code{data} that contains the
southern most latitude coordinate}

\item{west}{String specifying the column of \code{data} that contains the
western most longitude}

\item{id}{string specifying the column containing an identifier for a rectangle}

\item{draggable}{string specifying the column of \code{data} defining if the rectangle
is 'draggable' (either TRUE or FALSE)}

\item{editable}{string specifying the column of \code{data} defining if the rectangle
is 'editable' (either TRUE or FALSE)}

\item{stroke_colour}{either a string specifying the column of \code{data} containing
the stroke colour of each rectangle, or a valid hexadecimal numeric HTML style to
be applied to all the rectangle}

\item{stroke_opacity}{either a string specifying the column of \code{data} containing
the stroke opacity of each rectangle, or a value between 0 and 1 that will be
applied to all the rectangle}

\item{stroke_weight}{either a string specifying the column of \code{data} containing
the stroke weight of each rectangle, or a number indicating the width of pixels
in the line to be applied to all the rectangle}

\item{fill_colour}{either a string specifying the column of \code{data} containing
the fill colour of each rectangle, or a valid hexadecimal numeric HTML style to
be applied to all the rectangle}

\item{fill_opacity}{either a string specifying the column of \code{data} containing
the fill opacity of each rectangle, or a value between 0 and 1 that will be applied to all the rectangles}

\item{mouse_over}{string specifying the column of data to display when the
mouse rolls over the rectangle}

\item{mouse_over_group}{string specifying the column of data specifying which
groups of rectangle to highlight on mouseover}

\item{info_window}{string specifying the column of data to display in an info
window when a rectangle is clicked}

\item{layer_id}{single value specifying an id for the layer.}

\item{z_index}{single value specifying where the rectangles appear in the layering
of the map objects. Layers with a higher \code{z_index} appear on top of those with
a lower \code{z_index}. See details.}

\item{digits}{integer. Use this parameter to specify how many digits (decimal places)
should be used for the latitude / longitude coordinates.}
}
\description{
Adds a rectangle to a google map
}
\details{
\code{z_index} values define the order in which objects appear on the map.
Those with a higher value appear on top of those with a lower value. The default
order of objects is (1 being underneath all other objects)

\itemize{
  \item{1. Polygon}
  \item{2. Rectangle}
  \item{3. Polyline}
  \item{4. Circle}
}

Markers are always the top layer
}
\examples{
\dontrun{

map_key <- 'your_api_key'

df <- data.frame(north = 33.685, south = 33.671, east = -116.234, west = -116.251)

google_map(key = map_key) \%>\%
  add_rectangles(data = df, north = 'north', south = 'south',
                 east = 'east', west = 'west')

## editable rectangle
df <- data.frame(north = -37.8459, south = -37.8508, east = 144.9378,
                  west = 144.9236, editable = T, draggable = T)

google_map(key = map_key) \%>\%
  add_rectangles(data = df, north = 'north', south = 'south',
                 east = 'east', west = 'west',
                 editable = 'editable', draggable = 'draggable')

}
}

