% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_ls.R
\name{gs_ls}
\alias{gs_ls}
\title{List sheets a la Google Sheets home screen}
\usage{
gs_ls(regex = NULL, ..., verbose = TRUE)
}
\arguments{
\item{regex}{character; one or more regular expressions; if non-\code{NULL}
only sheets whose titles match will be listed; multiple regular expressions
are concatenated with the vertical bar}

\item{...}{optional arguments to be passed to \code{\link{grep}} when
matching \code{regex} to sheet titles}

\item{verbose}{logical; do you want informative messages?}
}
\value{
a \code{googlesheet_ls} object, which is a
  \code{\link[dplyr]{tbl_df}} with one row per sheet (we use a custom class
  only to control how this object is printed)
}
\description{
Lists spreadsheets that the user would see in the Google Sheets home screen:
\url{https://docs.google.com/spreadsheets/}. This function returns the
information available from the
\href{https://developers.google.com/google-apps/spreadsheets/#retrieving_a_list_of_spreadsheets}{spreadsheets
feed} of the Google Sheets API. Since this is non-public user data, use of
\code{gs_ls} will require authorization
}
\details{
This listing gives a \emph{partial} view of the sheets available for access
(why just partial? see below). For these sheets, we retrieve sheet title,
sheet key, author, user's permission, date-time of last update, version (old
vs new sheet?), various links, and an alternate key (only relevant to old
sheets).

The resulting table provides a map between readily available information,
such as sheet title, and more obscure information you might use in scripts,
such as the sheet key. This sort of "table lookup" is exploited in the
functions \code{\link{gs_title}}, \code{\link{gs_key}}, \code{\link{gs_url}},
and \code{\link{gs_ws_feed}}, which register a sheet based on various forms
of user input.

Which sheets show up in this table? Certainly those owned by the user. But
also a subset of the sheets owned by others but visible to the user. We have
yet to find explicit Google documentation on this matter. Anecdotally, sheets
owned by a third party but for which the user has read access seem to appear
in this listing if the user has visited them in the browser. This is an
important point for usability because a sheet can be summoned by title
instead of key \emph{only} if it appears in this listing. For shared sheets
that may not appear in this listing, a more robust workflow is to specify the
sheet via its browser URL or unique sheet key.
}
\examples{
\dontrun{
gs_ls()

yo_names <- paste0(c("yo", "YO"), c("", 1:3))
yo_ret <- yo_names \%>\% lapply(gs_new)
gs_ls("yo")
gs_ls("yo", ignore.case = TRUE)
gs_ls("yo[23]", ignore.case = TRUE)
gs_grepdel("yo", ignore.case = TRUE)
gs_ls("yo", ignore.case = TRUE)

c("foo", "yo") \%>\% lapply(gs_new)
gs_ls("yo")
gs_ls("yo|foo")
gs_ls(c("foo", "yo"))
gs_vecdel(c("foo", "yo"))

}

}
