% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/team_drive_create.R
\name{team_drive_create}
\alias{team_drive_create}
\title{Create a new Team Drive}
\usage{
team_drive_create(name, verbose = TRUE)
}
\arguments{
\item{name}{Character. Name of the new Team Drive. Must be non-empty and not
entirely whitespace.}

\item{verbose}{Logical, indicating whether to print informative messages
(default \code{TRUE}).}
}
\value{
An object of class \code{\link{dribble}}, a tibble with one row per item.
}
\description{
Note: \href{https://gsuite.google.com/learning-center/products/drive/get-started-team-drive/}{Team Drives}
are only available to users of certain enhanced Google services, such as G
Suite Enterprise, G Suite Business, or G Suite for Education.
}
\examples{
\dontrun{
team_drive_create("my-awesome-team-drive")

## clean up
team_drive_rm("my-awesome-team-drive")
}
}
\seealso{
Wraps the \code{teamdrives.create} endpoint:
\itemize{
\item \url{https://developers.google.com/drive/v3/reference/teamdrives/create}
}
}
