% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_cp.R
\name{drive_cp}
\alias{drive_cp}
\title{Copy a Drive file}
\usage{
drive_cp(file, path = NULL, name = NULL, ..., verbose = TRUE)
}
\arguments{
\item{file}{Something that identifies the file of interest on your Google
Drive. Can be a name or path, a file id or URL marked with
\code{\link{as_id}()}, or a \code{\link{dribble}}.}

\item{path}{Specifies target destination for the new file on Google
Drive. Can be an actual path (character), a file id marked with
\code{\link{as_id}()}, or a \code{\link{dribble}}. If specified as an
actual path, it is best to explicitly indicate if it's a folder by
including a trailing slash, since it cannot always be worked out from the
context of the call. Defaults to "Copy of \code{FILE-NAME}".}

\item{name}{Character, new file name if not specified as part of
\code{path}. This will force \code{path} to be treated as a folder, even if
it is character and lacks a trailing slash. Defaults to "Copy of \code{FILE-NAME}".}

\item{...}{Named parameters to pass along to the Drive API. You can affect
the metadata of the target file by specifying properties of the Files
resource via \code{...}. See the "Request body" section of the Drive API
docs for the associated endpoint.}

\item{verbose}{Logical, indicating whether to print informative messages
(default \code{TRUE}).}
}
\value{
An object of class \code{\link{dribble}}, a tibble with one row per
  item.
}
\description{
Copies an existing Drive file into a new file id.
}
\examples{
\dontrun{
## Create a file to copy
file <- drive_upload(drive_example("chicken.txt"), "chicken-cp.txt")

## Make a "Copy of" copy in same folder as the original
drive_cp("chicken-cp.txt")

## Make an explicitly named copy in same folder as the original
drive_cp("chicken-cp.txt", "chicken-cp-two.txt")

## Make an explicitly named copy in a different folder
folder <- drive_mkdir("new-folder")
drive_cp("chicken-cp.txt", path = folder, name = "chicken-cp-three.txt")

## Make an explicitly named copy and star it.
## The starring is an example of providing metadata via `...`.
## `starred` is not an actual argument to `drive_cp()`,
## it just gets passed through to the API.
drive_cp("chicken-cp.txt", name = "chicken-cp-starred.txt", starred = TRUE)

## Behold all of our copies!
drive_find("chicken-cp")

## Delete all of our copies and the new folder!
drive_find("chicken-cp") \%>\% drive_rm()
drive_rm(folder)

## upload a csv file to copy
csv_file <- drive_upload(drive_example("chicken.csv"))

## copy AND AT THE SAME TIME convert it to a Google Sheet
chicken_sheet <- drive_cp(
  csv_file,
  name = "chicken-cp",
  mime_type = drive_mime_type("spreadsheet")
)

## go see the new Sheet in the browser
## drive_browse(chicken_sheet)

## clean up
drive_rm(csv_file, chicken_sheet)
}
}
\seealso{
Wraps the \code{files.copy} endpoint:
\itemize{
\item \url{https://developers.google.com/drive/v3/reference/files/copy}
}
}
