% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/containers.R
\name{gtm_containers_delete}
\alias{gtm_containers_delete}
\title{Deletes an existing GTM Container.}
\usage{
gtm_containers_delete(account_id, container_id, force = c("TRUE", "FALSE"))
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}

\item{force}{Force deletion without user input}
}
\description{
This deletes a GTM container from an account. This is an irreversible process, so it's recommended that you first back up the container.
}
\examples{
\dontrun{

accountId <- 1234567
containerId <- 7654321
gtm_conainers_delete(accountId, containerId, "TRUE")


containerId <- 7654567

gtm_containers_delete(accountId, containerId)

# !!WARNING!! This command will delete your container.
# This operation is irrevocable.
# It is strongly recommended that you create an export of your container 
# before you delete it, just in case you ever want it again.
# Are you sure you want to continue?

#  1: Yes
#  2: No

# Selection: 1

# Are You really sure you want to delete this container?

#  1: Yes
#  2: No

# Selection: 1

# Container 7654567 has been deleted.

}

}
\seealso{
\url{https://developers.google.com/tag-manager/api/v2/reference/accounts/containers/delete}

Other container functions: 
\code{\link{gtm_containers_create}()},
\code{\link{gtm_containers_get}()},
\code{\link{gtm_containers_list}()},
\code{\link{gtm_containers_update}()}
}
\concept{container functions}
