% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudbuild_schedule.R
\name{cr_schedule_build}
\alias{cr_schedule_build}
\title{Schedule a Build object via HTTP or PubSub}
\usage{
cr_schedule_build(
  build,
  schedule,
  schedule_type = c("http", "pubsub"),
  email = cr_email_get(),
  projectId = cr_project_get(),
  ...
)
}
\arguments{
\item{build}{A Build object}

\item{schedule}{A cron schedule e.g. \code{"15 5 * * *"}}

\item{schedule_type}{Whether to use HTTP or PubSub styled schedules}

\item{email}{The email that will authenticate the job set via \link{cr_email_set}}

\item{projectId}{The GCP project to run within usually set with \link{cr_project_set}}

\item{...}{
  Arguments passed on to \code{\link[=cr_schedule]{cr_schedule}}
  \describe{
    \item{\code{region}}{The region usually set with \link{cr_region_set}}
    \item{\code{overwrite}}{If TRUE and an existing job with the same name exists, will overwrite it with the new parameters}
    \item{\code{name}}{Name to call your scheduled job}
    \item{\code{httpTarget}}{A HTTP target object \link{HttpTarget}}
    \item{\code{pubsubTarget}}{A Pub/Sub target object \link{PubsubTarget} such as created via \link{cr_schedule_pubsub}}
    \item{\code{description}}{Optionally caller-specified in CreateJob or}
    \item{\code{timeZone}}{Specifies the time zone to be used in interpreting schedule. If set to \code{NULL} will be "UTC". Note that some time zones include a provision for daylight savings time.}
  }}
}
\value{
\code{cr_schedule_build} returns a cloud scheduler \link{Job} object
}
\description{
Schedule a Build object via HTTP or PubSub
}
\details{
See also \link{cr_schedule} which you can use by to customise your schedule.
}
