% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudbuild.R
\name{cr_build_make}
\alias{cr_build_make}
\title{Make a Cloud Build object out of a cloudbuild.yml file}
\usage{
cr_build_make(
  yaml,
  source = NULL,
  timeout = NULL,
  images = NULL,
  artifacts = NULL,
  options = NULL,
  substitutions = NULL,
  projectId = cr_project_get()
)
}
\arguments{
\item{yaml}{A \code{Yaml} object created from \link{cr_build_yaml} or a file location of a .yaml/.yml cloud build file}

\item{source}{A \link{Source} object specifying the location of the source files to build, usually created by \link{cr_build_source}}

\item{timeout}{Amount of time that this build should be allowed to run, to second}

\item{images}{A list of images to be pushed upon the successful completion of all build}

\item{artifacts}{Artifacts that may be built via \link{cr_build_yaml_artifact}}

\item{options}{Options}

\item{substitutions}{Substitutions data for `Build` resource}

\item{projectId}{ID of the project}
}
\description{
This creates a \link{Build} object via the standard cloudbuild.yaml format
}
\examples{
cloudbuild <- system.file("cloudbuild/cloudbuild.yaml",
                           package = "googleCloudRunner")
cr_build_make(cloudbuild, projectId = "test-project")
}
\seealso{
https://cloud.google.com/cloud-build/docs/build-config

Other Cloud Build functions: 
\code{\link{Build}()},
\code{\link{RepoSource}()},
\code{\link{Source}()},
\code{\link{StorageSource}()},
\code{\link{cr_build_artifacts}()},
\code{\link{cr_build_status}()},
\code{\link{cr_build_upload_gcs}()},
\code{\link{cr_build_wait}()},
\code{\link{cr_build_write}()},
\code{\link{cr_build_yaml_artifact}()},
\code{\link{cr_build_yaml}()},
\code{\link{cr_build}()}
}
\concept{Cloud Build functions}
