% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/users.R
\name{ga_users_add}
\alias{ga_users_add}
\title{Create or update user access to Google Analytics}
\usage{
ga_users_add(email, permissions, accountId, webPropertyId = NULL,
  viewId = NULL)
}
\arguments{
\item{email}{The email(s) of the user(s) to add.  Has to have a Google account.}

\item{permissions}{Which permissions to add as a vector - \code{"MANAGE_USERS"},\code{"EDIT"},\code{"COLLABORATE"},\code{"READ_AND_ANALYZE"}}

\item{accountId}{Account Id}

\item{webPropertyId}{Web Property Id - set to NULL to operate on account level only}

\item{viewId}{viewId - set to NULL to operate on webProperty level only}
}
\value{
\code{TRUE} if successful
}
\description{
If you supply more than one \code{email}, then batch processing will be applied.  Batching has special rules that give you 30 operations for the cost of one API call against your quota. When batching you will only get a \code{TRUE} result on successful batch, but individual entries may have failed.  Check via \link{ga_users_list} afterwards and try to add individual linkIds to get more descriptive error messages.
}
\examples{

\dontrun{
library(googleAnalyticsR)
ga_auth()

ga_users_add(c("the_email@company.com", "another_email@company.com"), 
             permissions = "EDIT", accountId = 47480439)

}
}
\seealso{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/user-management}{Google help article on user permissions}

Other User management functions: \code{\link{ga_users_delete_linkid}},
  \code{\link{ga_users_delete}},
  \code{\link{ga_users_list}},
  \code{\link{ga_users_update}}
}
\concept{User management functions}
