% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_schedule.R
\name{load_schedule}
\alias{load_schedule}
\alias{get_pga_schedule}
\title{Load Golf Schedule}
\usage{
load_schedule(year = as.integer(format(Sys.Date(), "\%Y")), tour = "pga")

get_pga_schedule(year = format(Sys.Date(), "\%Y"))
}
\arguments{
\item{year}{Season year (e.g., 2026). Defaults to current year.}

\item{tour}{Tour identifier. Currently supports "pga" (default).}
}
\value{
A tibble with columns:
  \itemize{
    \item \code{event_id}: ESPN event identifier
    \item \code{tournament_name}: Tournament name
    \item \code{start_date}: Tournament start date
    \item \code{end_date}: Tournament end date
  }

A tibble with tournament schedule data
}
\description{
Retrieves the tournament schedule for a given year and tour.
}
\section{Functions}{
\itemize{
\item \code{get_pga_schedule()}: Legacy function for backwards compatibility

}}
\examples{
\donttest{
# Get current year schedule
schedule <- load_schedule()

# Get specific year
schedule_2025 <- load_schedule(2025)
}
}
