% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{set_golem_options}
\alias{set_golem_options}
\alias{set_golem_wd}
\alias{set_golem_name}
\alias{set_golem_version}
\alias{get_golem_wd}
\alias{get_golem_name}
\alias{get_golem_version}
\title{\code{{golem}} options}
\usage{
set_golem_options(
  golem_name = pkgload::pkg_name(),
  golem_version = pkgload::pkg_version(),
  golem_wd = pkgload::pkg_path(),
  app_prod = FALSE,
  talkative = TRUE
)

set_golem_wd(path = pkgload::pkg_path(), talkative = TRUE)

set_golem_name(
  name = pkgload::pkg_name(),
  path = pkgload::pkg_path(),
  talkative = TRUE
)

set_golem_version(
  version = pkgload::pkg_version(),
  path = pkgload::pkg_path(),
  talkative = TRUE
)

get_golem_wd(use_parent = TRUE, path = pkgload::pkg_path())

get_golem_name(
  config = Sys.getenv("R_CONFIG_ACTIVE", "default"),
  use_parent = TRUE,
  path = pkgload::pkg_path()
)

get_golem_version(
  config = Sys.getenv("R_CONFIG_ACTIVE", "default"),
  use_parent = TRUE,
  path = pkgload::pkg_path()
)
}
\arguments{
\item{golem_name}{Name of the current golem.}

\item{golem_version}{Version of the current golem.}

\item{golem_wd}{Working directory of the current golem package.}

\item{app_prod}{Is the \code{{golem}} in prod mode?}

\item{talkative}{Should the messages be printed to the console?}

\item{path}{The path to set the golem working directory.
Note that it will be passed to \code{normalizePath}.}

\item{name}{The name of the app}

\item{version}{The version of the app}

\item{use_parent}{\code{TRUE} to scan parent directories for
configuration files if the specified config file isn't found.}

\item{config}{Name of configuration to read from. Defaults to
the value of the \code{R_CONFIG_ACTIVE} environment variable
("default" if the variable does not exist).}
}
\value{
Used for side-effects for the setters, and values from the
config in the getters.
}
\description{
Set and get a series of options to be used with \code{{golem}}.
These options are found inside the \code{golem-config.yml} file, found in most cases
inside the \code{inst} folder.
}
\section{Set Functions}{

\itemize{
\item \code{set_golem_options()} sets all the options, with the defaults from the functions below.
\item \code{set_golem_wd()} defaults to \code{here::here()}, which is the package root when starting a golem.
\item \code{set_golem_name()} defaults \code{pkgload::pkg_name()}
\item \code{set_golem_version()} defaults \code{pkgload::pkg_version()}
}
}

\section{Get Functions}{

Reads the information from \code{golem-config.yml}
\itemize{
\item \code{get_golem_wd()}
\item \code{get_golem_name()}
\item \code{get_golem_version()}
}
}

