% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_output.R
\name{print-method}
\alias{print-method}
\alias{print.result.goldfish}
\alias{print.summary.result.goldfish}
\alias{print.nodes.goldfish}
\alias{print.network.goldfish}
\alias{print.dependent.goldfish}
\alias{print.preprocessed.goldfish}
\title{Methods for \code{goldfish} objects.}
\usage{
\method{print}{result.goldfish}(
  x,
  ...,
  digits = max(3, getOption("digits") - 2),
  width = getOption("width"),
  complete = FALSE
)

\method{print}{summary.result.goldfish}(
  x,
  ...,
  digits = max(3, getOption("digits") - 2),
  width = getOption("width"),
  complete = FALSE
)

\method{print}{nodes.goldfish}(x, ..., full = FALSE, n = 6)

\method{print}{network.goldfish}(x, ..., full = FALSE, n = 6L)

\method{print}{dependent.goldfish}(x, ..., full = FALSE, n = 6)

\method{print}{preprocessed.goldfish}(x, ..., width = getOption("width"))
}
\arguments{
\item{x}{an object of class \code{result.goldfish}, \code{summary.result.goldfish},
\code{nodes.goldfish}, \code{network.goldfish}, \code{dependent.goldfish}, or
\code{preprocessed.goldfish}.}

\item{...}{further arguments to be passed to the respective \code{default}
method.}

\item{digits}{minimal number of significant digits, see \code{\link[=print.default]{print.default()}}.}

\item{width}{controls the maximum number of columns on a line used in
printing \code{summary.result.goldfish} and \code{preprocessed.goldfish},
see  \code{\link[=print.default]{print.default()}}.}

\item{complete}{logical. Indicates whether the parameter coefficients
of effects fixed during estimation using \code{fixedParameters} should be printed.
The default value is \code{FALSE}. \emph{Note:} applies for objects of class
\code{result.goldfish} and \code{summary.result.goldfish}.}

\item{full}{logical. Indicates whether the complete \code{matrix}/\code{data.frame}
should be printed. The default value \code{FALSE}.}

\item{n}{number of rows for \code{data.frame}, and rows and columns for
\code{matrix} to be printed.}
}
\value{
Not value, called for printing side effect.

For objects of class \code{result.goldfish} and \code{summary.result.goldfish}
print the estimated coefficients when \code{complete = FALSE}, otherwise it
includes also the fixed coefficients.
For \code{summary.result.goldfish} print:
\item{Effect details:}{a table with additional information of the effects.
The information corresponds to the  values of the effects arguments when
they are modified and if they where fixed during estimation, see
\code{vignette("goldfishEffects")} for the complete list of arguments, and
\code{\link[=estimate]{estimate()}} on how to fix coefficients during estimation.}
\item{Coefficients:}{a table with the estimated coefficients, their
approximate standard error obtain from the inverse of the negative Fisher
information matrix, z-value and the p-value of the univariate two-tailed
Wald test to test the hypothesis that the parameter is 0.}
\item{Convergence and Information Criteria:}{Information about the
convergence of the iterative Newton-Raphson procedure and the score value
in the last iteration. Information criteria as the AIC, BIC and the AIC
corrected for small sample size AICc are reported.}
\item{Model and subModel:}{the values set during estimation.}

For objects of class \code{nodes.goldfish} print information of the total
number of nodes in the object, the number of nodes present at the beginning
of preprocessing, a table with the linked attributes with their respective
events data frame and a printing of the first rows in the nodes data frame.
See \code{\link[=defineNodes]{defineNodes()}}.

For objects of class \code{network.goldfish} print information of the
dimensions of the network, number of ties presented at the beginning of the
preprocessing, the nodes data frames linked to it, information about their
definition as a one-mode and directed network, linked events data frame to it
and a printing of the first rows and columns in the array.
See \code{\link[=defineNetwork]{defineNetwork()}}.

For objects of class \code{dependent.goldfish} print information of the
total number of events in the object, linked nodes set(s),
linked default network
and a printing of the first rows in the events data frame.
See \code{\link[=defineDependentEvents]{defineDependentEvents()}}.
}
\description{
Printing functions for \code{goldfish} objects.
}
