% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.R
\name{residuals.joint}
\alias{residuals.joint}
\title{Obtain joint model residuals}
\usage{
\method{residuals}{joint}(
  object,
  data = NULL,
  what = c("longit", "surv"),
  type = c("response", "pearson"),
  ...
)
}
\arguments{
\item{object}{a joint model fit by \code{\link{joint}} function.}

\item{data}{the \emph{original} data set (i.e. that used in the \code{joint} call).}

\item{what}{character string. Should the \code{"long"}itudinal process(es) be extracted,
or the \code{"surv"}ival ones?}

\item{type}{character. The residual type for \code{what = "long"} residuals only. Choices are
on the \code{"response"} scale or \code{"pearson"} residuals. Cox-Snell residuals are 
returend if \code{what = "surv"}.}

\item{...}{Additional arguments (none used).}
}
\value{
a named list of length \eqn{K} of class \code{residuals.joint} containing
residuals produced by the joint model for each of the \eqn{k=1,\dots,K} responses, 
along with the fitted values as an attribute.
}
\description{
returns the Pearson residuals values from a \code{joint} object.
}
\examples{
\donttest{
# Trivariate fit on PBC data -----------------------------------------
data(PBC)

# Subset data and remove NAs
PBC <- subset(PBC, select = c('id', 'survtime', 'status', 'drug', 'time',
                              'albumin', 'ascites', 'platelets'))
PBC <- na.omit(PBC) 

# Specify trivariate fit
long.formulas <- list(
  albumin ~ time*drug + (1 + time|id),
  platelets ~ time * drug + (1 + time|id),
  ascites ~ time * drug + (1|id)
)
surv.formula <- Surv(survtime, status) ~ drug

fit <- joint(long.formulas, surv.formula, PBC, 
             family = list('gaussian', 'poisson', 'binomial'))
R <- residuals(fit, type = 'pearson')
plot(R)
plot(residuals(fit, what = "surv"))
}
}
\seealso{
\code{\link{fitted.joint}} \code{\link{plot.residuals.joint}}
}
\author{
James Murray (\email{j.murray7@ncl.ac.uk}).
}
