% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argumentChecks.R
\name{check_same_means}
\alias{check_same_means}
\title{Check whether the parametrization is correct for usage of same means restrictions}
\usage{
check_same_means(parametrization, same_means)
}
\arguments{
\item{parametrization}{\code{"intercept"} or \code{"mean"} determining whether the model is parametrized with intercept
parameters \eqn{\phi_{m,0}} or regime means \eqn{\mu_{m}}, m=1,...,M.}

\item{same_means}{Restrict the mean parameters of some regimes to be the same? Provide a list of numeric vectors
such that each numeric vector contains the regimes that should share the common mean parameters. For instance, if
\code{M=3}, the argument \code{list(1, 2:3)} restricts the mean parameters of the second and third regime to be
the same but the first regime has freely estimated (unconditional) mean. Ignore or set to \code{NULL} if mean parameters
should not be restricted to be the same among any regimes. \strong{This constraint is available only for mean parametrized models;
that is, when \code{parametrization="mean"}.}}
}
\value{
Throws an error if parametrization type is not "mean" and means are constrained
}
\description{
\code{check_same_means} checks whether the parametrization is correct for
 usage of same means restrictions
}
\keyword{internal}
