% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncorrelationTest.R
\name{noSpatCorr.test}
\alias{noSpatCorr.test}
\alias{noSpatCorr.test.data.frame}
\alias{noSpatCorr.test.default}
\alias{noSpatCorr.test.matrix}
\title{Test for lack of spatial correlation}
\usage{
noSpatCorr.test(Z, ...)

\method{noSpatCorr.test}{data.frame}(Z, X, ...)

\method{noSpatCorr.test}{default}(Z, ...)

\method{noSpatCorr.test}{matrix}(
  Z,
  X,
  R = 299,
  maxlag0 = 0.1 * max(as.matrix(dist(X))),
  minlagInf = 0.25 * max(as.matrix(dist(X))),
  ...
)
}
\arguments{
\item{Z}{matrix (or equivalent) of scaled observations}

\item{...}{extra arguments for generic functionality}

\item{X}{matrix (or equivalent) of sample location coordinates}

\item{R}{number of realizations of the Monte Carlo test}

\item{maxlag0}{maximum lag distance to consider in the short range covariance}

\item{minlagInf}{minimum lag distance to consider in the long range covariance}
}
\value{
Produces a test of lack of spatial correlation by means of permutations. The test
statistic is based on the smallest eigenvalue of the generalised eigenvalues of the matrices
of covariance for short range and for long range.
}
\description{
Permutation test for checking lack of spatial correlation.
}
\section{Methods (by class)}{
\itemize{
\item \code{data.frame}: Test for lack of spatial correlation

\item \code{default}: Test for lack of spatial correlation, works only for
Spatial objects with a "data" slot

\item \code{matrix}: Test for lack of spatial correlation
}}

\examples{
data("jura", package="gstat")
X = jura.pred[, 1:2]
Z = data.frame(compositions::ilr(jura.pred[,-(1:6)]))
\dontrun{ 
noSpatCorr.test(Z=Z, X=X)
# now destroy the spatial structure reshuffling the coordinates:
ip = sample(nrow(X))
noSpatCorr.test(Z=Z, X=X[ip,]) 
}
}
