% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variograms.R
\name{plot.gmCgram}
\alias{plot.gmCgram}
\title{Draw cuves for covariance/variogram models}
\usage{
\method{plot}{gmCgram}(
  x,
  xlim.up = NULL,
  xlim.lo = NULL,
  vdir.up = NULL,
  vdir.lo = NULL,
  xlength = 200,
  varnames = colnames(x$nugget),
  add = FALSE,
  commonAxis = TRUE,
  cov = TRUE,
  closeplot = TRUE,
  ...
)
}
\arguments{
\item{x}{object to draw, of class gmCgram // curently only valid for symmetric functions}

\item{xlim.up}{range of lag values to use in plots of the upper triangle}

\item{xlim.lo}{range of lag values to use in plots of the lower triangle}

\item{vdir.up}{geograohic directions to represent in the upper triangle}

\item{vdir.lo}{geograohic directions to represent in the lower triangle}

\item{xlength}{number of discretization points to use for the curves (defaults to 200)}

\item{varnames}{string vector, variable names to use in the labelling of axes}

\item{add}{logical, should a new plot be created or stuff be added to an existing one?}

\item{commonAxis}{logical, is a common Y axis for all plots in a row desired?}

\item{cov}{logical, should the covariance function (=TRUE) or the variogram (=FALSE) be plotted?}

\item{closeplot}{logical, should the plot be left open (FALSE) for further changes, or be frozen (TRUE)?
defaults to TRUE}

\item{...}{further graphical parameters for the plotting function}
}
\value{
This function is called for its side effect of producing a plot: the plot will be
open to further changes if you provide \code{closeplot=FALSE}. Additionally, the function
invisibly returns the graphical parameters that were active before starting the plot. Hence,
if you want to freeze a plot and not add anymore to it, you can do \code{par(plot(x, closeplot=FALSE, ...))},
or \code{plot(x, closeplot=TRUE, ...)}.
If you want to further add stuff to it, better just call \code{plot(x, closeplot=FALSE,...)}. The difference
is only relevant when working with the screen graphical device.
}
\description{
Represent a gmCgram object as a matrix of lines in several plots
}
\examples{
utils::data("variogramModels")
v1 = setCgram(type=vg.Gau, sill=diag(3)-0.5, anisRanges = 2*diag(c(3,0.5)))
v2 = setCgram(type=vg.Exp, sill=0.3*diag(3), anisRanges = 0.5*diag(2))
vm = v1+v2
plot(vm)
plot(vm, cov=FALSE)
}
\seealso{
Other gmCgram functions: 
\code{\link{[.gmCgram}()},
\code{\link{[[.gmCgram}()},
\code{\link{as.function.gmCgram}()},
\code{\link{as.gmCgram.variogramModelList}()},
\code{\link{length.gmCgram}()},
\code{\link{ndirections}()},
\code{\link{variogramModelPlot}()}
}
\concept{gmCgram functions}
