% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmSpatialModel.R
\name{predict.gmSpatialModel}
\alias{predict.gmSpatialModel}
\title{Predict method for objects of class 'gmSpatialModel'}
\usage{
\method{predict}{gmSpatialModel}(object, newdata = NULL, pars = object@parameters, ...)
}
\arguments{
\item{object}{a complete "gmSpatialModel", containing conditioning data and unconditional model}

\item{newdata}{a collection of locations where a prediction/simulation is desired; this is typically
a \code{\link[sp:SpatialPoints]{sp::SpatialPoints()}}, a data.frame or similar of X-Y(-Z) coordinates; or perhaps for gridded data
an object of class  \code{\link[sp:GridTopology]{sp::GridTopology()}}, \code{\link[sp:SpatialGrid]{sp::SpatialGrid()}} or \code{\link[sp:SpatialPixels]{sp::SpatialPixels()}}}

\item{pars}{parameters describing the method to use, \emph{encloded in an object of appropriate class} (see below)}

\item{...}{further parameters for generic functionality, currently ignored}
}
\value{
Depending on the nature of \code{newdata}, the result will be a data container of the same kind,
extended with the predictions or simulations. For instance, if we want to obtain predictions on the
locations of a "SpatialPoints", the result will be a \code{\link[sp:SpatialPointsDataFrame]{sp::SpatialPointsDataFrame()}}; if we want to obtain
simulations on the coordinates provided by a "data.frame", the result will be a \code{\link[=DataFrameStack]{DataFrameStack()}} with
the spatial coordinates stored as an extra attribute; or if the input for a simulation is a masked grid of class
\code{\link[sp:SpatialPixels]{sp::SpatialPixels()}}, the result will be of class \code{\link[sp:SpatialPixelsDataFrame]{sp::SpatialPixelsDataFrame()}} which \code{data} slot will be
a \link{DataFrameStack}.
}
\description{
This is a one-entry function for several spatial prediction and simulation methods, for model objects
of class \linkS4class{gmSpatialModel}. The several methods are chosen by means of \code{pars} objects of the
appropriate class.
}
\details{
Package "gmGeostats" aims at providing a broad series of algorithms for geostatistical prediction
and simulation. All can be accesses through this interface, provided that arguments \code{object} and \code{pars} are of the
appropriate kind. In \code{object}, the most important criterion is the nature of its slot \code{model}. In \code{pars}
its class counts: for the creation of informative parameters in the appropriate format and class, a series
of accessory functions are provided as well.

Classical (gaussian-based two-point) geostatistics are obtained if \code{object@model} contains a covariance function,
or a variogram model. Argument \code{pars} can be created with functions such as \code{\link[=KrigingNeighbourhood]{KrigingNeighbourhood()}},
\code{\link[=SequentialSimulation]{SequentialSimulation()}}, \code{\link[=TurningBands]{TurningBands()}} or \code{\link[=CholeskyDecomposition]{CholeskyDecomposition()}} to respectively trigger a cokriging, as
sequential Gaussian simulation, a turning bands simulation, or a simulation via Cholesky decomposition.
The kriging neighbourhood can as well be incorporated in the "gmSpatialModel" \code{object} directly, or even be
nested in a "SequentialSimulation" parameter object.

Conversely, to run a multipoint geostatistics algorithm, the first condition is that \code{object@model} contains a
training image. Additionally, \code{pars} must describe the characteristics of the algorithm to use. Currently, only
direct sampling is available: it can be obtained by providing some parameter object created with a call to
\code{\link[=DirectSamplingParameters]{DirectSamplingParameters()}}. Currently it is also necessary that \code{newdata} is a gridded set of locations.
}
\seealso{
Other gmSpatialModel: 
\code{\link{as.gmSpatialModel}()},
\code{\link{gmSpatialModel-class}},
\code{\link{make.gmCompositionalGaussianSpatialModel}()},
\code{\link{make.gmCompositionalMPSSpatialModel}()},
\code{\link{make.gmMultivariateGaussianSpatialModel}()}
}
\concept{gmSpatialModel}
