% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glottomap.R
\name{glottomap}
\alias{glottomap}
\title{Create static and dynamic maps from glottodata, or select languages from a map}
\usage{
glottomap(
  glottodata = NULL,
  color = NULL,
  label = NULL,
  type = NULL,
  ptsize = NULL,
  alpha = NULL,
  lbsize = NULL,
  palette = NULL,
  rivers = FALSE,
  nclass = NULL,
  numcat = FALSE,
  filename = NULL,
  projection = NULL,
  mode = NULL,
  ...
)
}
\arguments{
\item{glottodata}{Optional, user-provided glottodata. In case no glottodata is provided, you can pass arguments directly to glottofilter.}

\item{color}{glottovar, column name, or column index to be used to color features (optional). Run glottovars() to see glottovars}

\item{label}{glottovar, column name, or column index to be used to label features (optional). Run glottovars() to see glottovars}

\item{type}{One of: "static", "dynamic", or "filter". Default is "static".}

\item{ptsize}{Size of points between 0 and 1}

\item{alpha}{Transparency of points between 0 (very transparent) and 1 (not transparent)}

\item{lbsize}{Size of labels between 0 and 1}

\item{palette}{Color palette, see glottocolpal("all") for possible options, and run glottocolpal("turbo") to see what it looks like (replace it with palette name).
Alternatively, you could also run tmaptools::palette_explorer(), RColorBrewer::display.brewer.all(), ?viridisLite::viridis, or scales::show_col(viridisLite::viridis(n=20))}

\item{rivers}{Do you want to plot rivers (only for static maps)?}

\item{nclass}{Preferred number of classes (default is 5)}

\item{numcat}{Do numbers represent categories? For example, if your dataset consists of 0 and 1, you might want to set this to TRUE.}

\item{filename}{Optional filename if you want to save resulting map}

\item{projection}{For static maps, you can choose one of the following: 'eqarea' (equal-area Eckert IV, default), 'pacific' (Pacific-centered), or any other Coordinate Reference System, specified using an EPSG code (https://epsg.io/).}

\item{mode}{In case type = "filter", you can set mode to either "draw" or "click".}

\item{...}{Additional parameters to glottofilter}
}
\value{
a map created from a glotto(sub)data object and can be saved with glottosave()
}
\description{
With this function you can easily create static and dynamic maps from glottodata (by setting type to 'static' or 'dynamic').
Alternatively, by specifying type = "filter", you can select languages by drawing/clicking on a map.
}
\examples{
\donttest{
glottomap(country = "Netherlands")

glottopoints <- glottofilter(continent = "South America")
glottopols <- glottospace(glottopoints, method = "voronoi")
glottomap(glottodata = glottopols, color = "family_size_rank")
glottomap(glottodata = glottopols, color = "family", palette = "turbo",
type = "dynamic", label = "name")

glottodata <- glottoget()
families <- dplyr::count(glottodata, family, sort = TRUE)

# highlight 10 largest families:
glottodata <- glottospotlight(glottodata = glottodata, spotcol =
"family", spotlight = families$family[1:10], spotcontrast = "family", bgcontrast = "family")

# Or, place 10 largest families in background
glottodata <- glottospotlight(glottodata = glottodata, spotcol =
"family", spotlight = families$family[-c(1:10)], spotcontrast = "family", bgcontrast = "family")
glottomap(glottodata, color = "color")
}
}
\concept{<glottomap>}
