% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cholecystectomy}
\alias{cholecystectomy}
\title{Shoulder Pain after Laparoscopic Cholecystectomy}
\format{
A data frame with 246 rows and 7 variables:
\describe{
  \item{id}{a numeric vector with the identifier of the patient.}
  \item{treatment}{a factor indicating the treatment received by the patient: abdominal suction ("A") and placebo ("P").}
  \item{gender}{a factor indicating the gender of the patient: female ("F") and male ("M").}
  \item{age}{a numeric vector indicating the age of the patient, in years.}
  \item{time}{a numeric vector indicating the occasion the patient was asked to rate their shoulder pain after the laparoscopic surgery: integers from 1 to 6.}
  \item{pain}{a numeric vector indicating the shoulder pain rated by the patient on a scale coded into five ordered categories, where
              1 indicated "low pain" and 5 reflected "high pain".}
  \item{pain2}{a numeric vector indicating the shoulder pain rated by the patient and coded as 1 for the two first categories of
               pain and 0 for other cases.}
}
}
\usage{
data(cholecystectomy)
}
\description{
Inflation of the abdomen during laparoscopic cholecystectomy
(removal of the gallbladder) separates the liver from the diaphragm and
places strain on the attachments that connect both. This strain is felt as
referred pain in the shoulder. Suction to remove residual gas may reduce
shoulder pain. There were 22 subjects randomized in the active group (with
abdominal suction) and 19 subjects randomized in the control group (without
abdominal suction). After laparoscopic surgery, patients were asked to rate
their shoulder pain on a visual analog scale morning and afternoon for three
days after the operation (a total of six different times). The scale was
coded into five ordered categories where a pain score of 1 indicated "low pain"
and a score of 5 reflected "high pain". See Jorgensen et al. (1995),
Lumley (1996), Morel and Nagaraj (2012, page 319).
}
\examples{
data(cholecystectomy)
out <- aggregate(pain2 ~ treatment + time, data=cholecystectomy, mean)
barplot(100*pain2 ~ treatment + time, beside=TRUE, data=out, xlab="Time",
        col=c("yellow","blue"), ylab="\% of patients with \"low\" pain")
legend(-1, 98, c("Placebo","Abdominal\n suction"), fill=c("yellow","blue"),
       bty="n", cex=0.6, x.intersp=0.2, y.intersp=1)

}
\references{
Jorgensen, J.O. and Gillies, R.B. and Hunt, D.R. and Caplehorn, J.R.M. and Lumley, T. (1995)
A simple and effective way to reduce postoperative pain after laparoscopic cholecystectomy.
\emph{Australian and New Zealand Journal of Surgery} 65, 466–469.

Lumley, T. (1996) Generalized Estimating Equations for Ordinal Data: A Note on Working Correlation Structures.
\emph{Biometrics} 52, 354–361.

Morel, J.G. and Nagaraj, N.K. (2012) \emph{Overdispersion Models in SAS}. SAS Institute Inc.,
Cary, North Carolina, USA.
}
\keyword{datasets}
