% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overglm3.R
\name{localInfluence.overglm}
\alias{localInfluence.overglm}
\title{Local Influence for alternatives to the Poisson and Binomial Regression Models under the presence of Overdispersion}
\usage{
\method{localInfluence}{overglm}(
  object,
  type = c("total", "local"),
  coefs,
  plot.it = FALSE,
  identify,
  ...
)
}
\arguments{
\item{object}{an object of class \emph{overglm}.}

\item{type}{an (optional) character string which allows to specify the local influence approach:
the absolute value of the elements of the main diagonal of the normal curvature matrix ("total") or
the eigenvector which corresponds to the maximum absolute eigenvalue of the normal curvature matrix ("local").
As default, \code{type} is set to "total".}

\item{coefs}{an (optional) character string which (partially) match with the names of some model parameters.}

\item{plot.it}{an (optional) logical indicating if the plot is required or just the data matrix in which that plot is based. As default, \code{plot.it} is set to FALSE.}

\item{identify}{an (optional) integer indicating the number of individuals to identify on the plot. This is only appropriate if \code{plot.it=TRUE}.}

\item{...}{further arguments passed to or from other methods. If \code{plot.it=TRUE} then \code{...} may be used
to include graphical parameters to customize the plot. For example, \code{col}, \code{pch}, \code{cex}, \code{main},
\code{sub}, \code{xlab}, \code{ylab}.}
}
\value{
A matrix as many rows as individuals in the sample and one column with the values of the local influence measure.
}
\description{
Computes local influence measures under the case-weight perturbation scheme for alternatives to the Poisson and
Binomial Regression Models under the presence of Overdispersion. Those local influence measures
may be chosen to correspond to all parameters in the linear predictor or (via \code{coefs}) for just some subset of them.
}
\examples{
###### Example 1: Self diagnozed ear infections in swimmers
data(swimmers)
fit1 <- overglm(infections ~ frequency + location, family="nb1(log)", data=swimmers)

### Local influence for all parameters in the linear predictor
localInfluence(fit1, type="local", plot.it=TRUE, col="red", lty=1, lwd=1, col.lab="blue",
               col.axis="blue", col.main="black", family="mono", cex=0.8)

### Local influence for the parameter associated with 'frequency'
localInfluence(fit1, type="local", plot.it=TRUE, col="red", lty=1, lwd=1, col.lab="blue",
               coef="frequency", col.axis="blue", col.main="black", family="mono", cex=0.8)

###### Example 2: Article production by graduate students in biochemistry PhD programs
bioChemists <- pscl::bioChemists
fit2 <- overglm(art ~ fem + kid5 + ment, family="nb1(log)", data = bioChemists)

### Local influence for all parameters in the linear predictor
localInfluence(fit2, type="local", plot.it=TRUE, col="red", lty=1, lwd=1, col.lab="blue",
               col.axis="blue", col.main="black", family="mono", cex=0.8)

### Local influence for the parameter associated with 'fem'
localInfluence(fit2, type="local", plot.it=TRUE, col="red", lty=1, lwd=1, col.lab="blue",
               coef="fem", col.axis="blue", col.main="black", family="mono", cex=0.8)

###### Example 3: Agents to stimulate cellular differentiation
data(cellular)
fit3 <- overglm(cbind(cells,200-cells) ~ tnf + ifn, family="bb(logit)", data=cellular)

### Local influence for all parameters in the linear predictor
localInfluence(fit3, type="local", plot.it=TRUE, col="red", lty=1, lwd=1, col.lab="blue",
               col.axis="blue", col.main="black", family="mono", cex=0.8)

### Local influence for the parameter associated with 'tnf'
localInfluence(fit3, type="local", plot.it=TRUE, col="red", lty=1, lwd=1, col.lab="blue",
               coef="tnf", col.axis="blue", col.main="black", family="mono", cex=0.8)

}
\references{
Cook R.D. (1986) Assessment of Local Influence. \emph{Journal of the Royal Statistical Society: Series B (Methodological)} 48, 133-155.
}
