% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{coupons}
\alias{coupons}
\title{Discount coupons}
\format{
A data frame with 11 rows and 3 variables:
\describe{
  \item{discounts}{a numeric vector indicating the price discount, in cents.}
  \item{costumers}{a numeric vector indicating the number of customers who received coupons.}
  \item{redeemed}{a numeric vector indicating the number of redeemed coupons.}
}
}
\usage{
data(coupons)
}
\description{
The market research department of a soft drink
manufacturer is investigating the effectiveness of a price discount
coupon on the purchase of a two-litre beverage product. A sample of
5500 costumers received coupons for varying price discounts between
5 and 25 cents. The main objective of the analysis is to determine
if the price discount affects the proportion of redeemed coupons
after one month.
}
\examples{
dev.new()
data(coupons)
barplot(100*redeemed/costumers ~ discounts, data=coupons, xlab="Discount price",
        ylab="(\%) Redeemed coupons", col="blue")
}
\references{
Montgomery D.C., Peck E.A., Vining G. (2012, page 464) \emph{Introduction to linear regression analysis. 5th ed.} Berlin, Wiley.
}
\keyword{datasets}
