% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geeglm.R
\name{predict.glmgee}
\alias{predict.glmgee}
\title{Predictions for Generalized Estimating Equations}
\usage{
\method{predict}{glmgee}(object, ..., newdata, se.fit = FALSE, type = c("link", "response"))
}
\arguments{
\item{object}{an object of the class glmgee which is obtained from the fit of a generalized estimating equation.}

\item{...}{further arguments passed to or from other methods.}

\item{newdata}{an (optional) \code{data frame} in which to look for variables with which to predict. If omitted, the fitted linear predictors are used.}

\item{se.fit}{an (optional) logical switch indicating if standard errors are required. By default, \code{se.fit} is set to be FALSE.}

\item{type}{an (optional) character string giving the type of prediction required. The default, "link", is on the scale of the linear predictors, and the alternative, "response", is on the scale of the response variable.}
}
\value{
A matrix with so many rows as \code{newdata} and one column with the predictions. If \code{se.fit=}TRUE then a second column with estimates standard errors is included.
}
\description{
Produces predictions and optionally estimates standard errors of those predictions from a fitted generalized estimating equation.
}
\examples{
mod <- size ~ poly(days,4) + treat
fit <- glmgee(mod, id=tree, family=Gamma("log"), data=spruce, corstr="Stationary-M-dependent(2)")
newdata <- data.frame(days=c(556,556),treat=as.factor(c("normal","ozone_enriched")))
predict(fit,newdata=newdata,type="response",se.fit=TRUE)
}
