% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extrafunctions.R
\name{hsgp_rescale}
\alias{hsgp_rescale}
\title{Rescales data to [-1,1]}
\usage{
hsgp_rescale(data, columns)
}
\arguments{
\item{data}{A data frame}

\item{columns}{Vector of integers. The indexes of the columns to be rescaled.}
}
\value{
A copy of the input data frame with rescaled columns
}
\description{
Rescales data to [-1,1] for HSGP model fitting
}
\details{
The HSGP covariance function requires that all dimensions are scaled to 
[-1,1] as conversion is not automatic. This function will rescale the D
covariance variables to [-1,1]^D while preserving their size relative to 
one another.
}
\examples{
df <- data.frame(x = runif(100,0,2), y = runif(100, -2,2))
df <- hsgp_rescale(df, 1:2)
}
