% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{confint.glmmTMB}
\alias{confint.glmmTMB}
\title{Calculate confidence intervals}
\usage{
\method{confint}{glmmTMB}(object, parm, level = 0.95, method = c("wald",
  "profile"), component = c("all", "cond", "zi", "other"), estimate = TRUE,
  ...)
}
\arguments{
\item{object}{\code{glmmTMB} fitted object.}

\item{parm}{Specification of a parameter subset \emph{after}
\code{component} subset has been applied.}

\item{level}{Confidence level.}

\item{method}{Currently only option is 'wald'.}

\item{component}{Which of the three components 'cond', 'zi' or
'other' to select. Default is to select 'all'.}

\item{estimate}{Logical; Add a 3rd column with estimate ?}

\item{...}{Not used}
}
\description{
Calculate confidence intervals
}
\details{
Currently, all confidence intervals are calculated using the
'wald' method. These intervals are based on the standard errors
calculated for parameters on the scale
of their internal parameterization depending on the family. Derived
quantities such as standard deviation parameters and dispersion
parameters are backtransformed. It follows that confidence
intervals for these derived quantities are asymmetric.
}
\examples{
data(sleepstudy, package="lme4")
model <- glmmTMB(Reaction ~ Days + (1|Subject), sleepstudy)
confint(model)
}
