% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmmSeq.R
\name{glmmSeq}
\alias{glmmSeq}
\title{GLMM with negative binomial distribution for sequencing count data}
\usage{
glmmSeq(
  modelFormula,
  countdata,
  metadata,
  id = NULL,
  dispersion,
  sizeFactors = NULL,
  reducedFormula = "",
  modelData = NULL,
  designMatrix = NULL,
  control = glmerControl(optimizer = "bobyqa"),
  cores = 1,
  removeSingles = FALSE,
  zeroCount = 0.125,
  verbose = TRUE,
  returnList = FALSE,
  progress = FALSE,
  ...
)
}
\arguments{
\item{modelFormula}{the model formula. This must be of the form \code{"~ ..."}
where the structure is assumed to be \code{"counts ~ ..."}. The formula must
include a random effects term. For more information on formula structure
for random effects see \code{\link[lme4:glmer]{lme4::glmer()}}}

\item{countdata}{the sequencing count data matrix with genes in rows and
samples in columns}

\item{metadata}{a dataframe of sample information with variables in columns
and samples in rows}

\item{id}{Optional. Used to specify the column in metadata which contains the
sample IDs to be used in repeated samples for random effects. If not
specified, the function defaults to using the variable after the "|" in the
random effects term in the formula.}

\item{dispersion}{a numeric vector of gene dispersion}

\item{sizeFactors}{size factors (default = NULL). If provided the \code{glmer}
offset is set to log(sizeFactors). For more information see``
\code{\link[lme4:glmer]{lme4::glmer()}}}

\item{reducedFormula}{Reduced design formula (default = "")}

\item{modelData}{Optional dataframe. Default is generated by call to
\code{expand.grid} using levels of variables in the formula. Used to calculate
model predictions (estimated means & 95\% CI) for plotting via \link{modelPlot}.
It can therefore be used to add/remove points in \link{modelPlot}.}

\item{designMatrix}{custom design matrix}

\item{control}{the \code{glmer} optimizer control (default =
\code{glmerControl(optimizer = "bobyqa")}). See
\code{\link[lme4:glmerControl]{lme4::glmerControl()}}.}

\item{cores}{number of cores to use. Default = 1.}

\item{removeSingles}{whether to remove individuals without repeated measures
(default = FALSE)}

\item{zeroCount}{numerical value to offset zeroes for the purpose of log
(default = 0.125)}

\item{verbose}{Logical whether to display messaging (default = TRUE)}

\item{returnList}{Logical whether to return results as a list or \code{glmmSeq}
object (default = FALSE). Useful for debugging.}

\item{progress}{Logical whether to display a progress bar}

\item{...}{Other parameters to pass to
\code{\link[lme4:glmer]{lme4::glmer()}}}
}
\value{
Returns an S4 class \code{GlmmSeq} object with results for gene-wise
general linear mixed models. A list of results is returned if \code{returnList}
is \code{TRUE} which is useful for debugging.
}
\description{
Fits many generalised linear mixed effects models (GLMM) with negative
binomial distribution for analysis of overdispersed count data with random
effects. Designed for longitudinal analysis of RNA-Sequencing count data.
Wald type 2 Chi-squared test is used to calculate p-values.
}
\details{
This function is a wrapper for \code{\link[lme4:glmer]{lme4::glmer()}}. Wald type 2 Chi-squared test
is calculated as per \code{\link[car:Anova]{car::Anova()}} optimised for speed. Parallelisation is
provided using \link[parallel:mclapply]{parallel::mclapply} on Unix/Mac or \link[parallel:clusterApply]{parallel::parLapply} on
PC.
}
\examples{
data(PEAC_minimal_load)
disp <- apply(tpm, 1, function(x) {
(var(x, na.rm = TRUE)-mean(x, na.rm = TRUE))/(mean(x, na.rm = TRUE)**2)
})
MS4A1glmm <- glmmSeq(~ Timepoint * EULAR_6m + (1 | PATID),
                     countdata = tpm[1:2, ],
                     metadata = metadata,
                     dispersion = disp,
                     verbose = FALSE)
names(attributes(MS4A1glmm))

}
