% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_generation.R, R/sim_generation_FA.R
\name{sim.data}
\alias{sim.data}
\alias{sim.data.FA}
\title{Simulates data to use for the \code{\link{glmmPen}} package}
\usage{
sim.data(
  n,
  ptot,
  pnonzero,
  nstudies,
  sd_raneff = 1,
  family = "binomial",
  corr = NULL,
  seed,
  imbalance = 0,
  beta = NULL,
  pnonzerovar = 0,
  sd_x = 1
)

sim.data.FA(
  n,
  ptot,
  pnonzero,
  nstudies,
  sd_raneff = 0,
  family = "binomial",
  B = NULL,
  r = 2,
  seed,
  imbalance = 0,
  beta = NULL,
  pnonzerovar = 0,
  sd_x = 1
)
}
\arguments{
\item{n}{integer specifying total number of samples to generate}

\item{ptot}{integer specifying total number of covariates to generate 
(values randomly generated from the standard normal distribution)}

\item{pnonzero}{integer specifying how may of the covariates should have
non-zero fixed and random effects}

\item{nstudies}{number of studies/groups to have in the data}

\item{sd_raneff}{non-negative value specifying the standard deviation of the
random effects covariance matrix (applied to the non-zero random effects)}

\item{family}{character string specifying which family to generate data from.
Family options include "binomial" (default), "poisson", and "gaussian".}

\item{corr}{optional value to specify correlation in the random effects
covariance matrix. Default \code{NULL}, only available within \code{sim.data}.}

\item{seed}{integer to use for the setting of a random seed}

\item{imbalance}{integer of 0 or 1 indicating whether the observations should
be equally distributed among the groups (0) or unequally distributed (1).}

\item{beta}{numeric vector of the fixed effects (including intercept)}

\item{pnonzerovar}{non-negative integer specifying the number of 
covariates with a zero-valued fixed effect but a non-zero random effect.}

\item{sd_x}{non-negative value specifying the standard deviation of the
simulated covariates (drawn from a normal distribution with mean 0,
standard deviation \code{sd_x})}

\item{B}{matrix specifying the factor loadings matrix for the random effects,
only used within \code{sim.data.FA}.
Dimensions: number of columns is the number of random effects (including the intercept),
and number of rows is the number of latent common factors (\code{r}).
The random effect covariance matrix is specified as Sigma = B x t(B) + diag(sd_raneff)}

\item{r}{positive integer specifying number of latent common factors that describe the random effects,
only used within \code{sim.data.FA}}
}
\value{
list containing the following elements:
\item{y}{vector of the response}
\item{X}{model matrix for the fixed effects}
\item{Z}{model matrix for the random effects, organized first by variable
and then by group}
\item{pnonzero}{number of non-zero fixed effects}
\item{z1}{values of the random effects for each variable for each level of 
the grouping factor}
\item{group}{grouping factor}
\item{X0}{model matrix for just the non-zero fixed effects}
}
\description{
Simulates data to use for testing the \code{\link{glmmPen}} package.
\code{sim.data} simulates data for \code{\link{glmmPen}}, and
\code{sim.data.FA} simulates data for \code{\link{glmmPen_FA}}.
Possible parameters to specify includes number of total covariates,
number of non-zero fixed and random effects, and the magnitude
of the random effect covariance values.
}
