context("test-method_cutpoints")

test_that("cutpoints works with continuous data", {
     x = matrix(runif(300), nrow = 100, ncol = 3)
     cuts = seq(0,1,length.out= 4)
     xd = apply(x,2, function(col) as.numeric(cut(col,cuts)))
     theta = t(matrix(c(0,0,0,2,2,2,-2,-2,-2),ncol=3,nrow=3))
     log_odd = rowSums(t(sapply(seq_along(xd[,1]), function(row_id) sapply(seq_along(xd[row_id,]), function(element) theta[xd[row_id,element],element]))))
     y = rbinom(100,1,1/(1+exp(-log_odd)))
     sem_disc <- glmdisc(x,y,iter=50,m_start=4,test=FALSE,validation=FALSE,criterion="aic")
     les_cuts = cutpoints(sem_disc)
     expect_type(les_cuts, "list")
     expect_length(les_cuts, 3)
     expect_type(les_cuts[[1]], "double")
     expect_equal(names(les_cuts), c("X1", "X2", "X3"))
})