% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_predict.R
\docType{methods}
\name{predict}
\alias{predict}
\alias{predict.glmdisc}
\alias{predict,glmdisc,ANY,ANY-method}
\alias{predict,glmdisc-method}
\title{Prediction on a raw test set of the best logistic regression model on discretized data.}
\usage{
predict.glmdisc(object, predictors)
}
\arguments{
\item{object}{The S4 discretization object.}

\item{predictors}{The test dataframe to discretize and for which we wish to have predictions.}
}
\description{
This defines the method "discretize" which will discretize a new input dataset given a discretization scheme of S4 class \code{\link{glmdisc}}

This defines the method "predict" which will predict the discretization of a new input dataset given a discretization scheme of S4 class \code{\link{glmdisc}}
}
\details{
This function discretizes a user-provided test dataset given a discretization scheme provided by an S4 "glmdisc" object.
It then applies the learnt logistic regression model and outputs its prediction (see \code{\link{predict.glm}}).

This function discretizes a user-provided test dataset given a discretization scheme provided by an S4 "glmdisc" object.
It then applies the learnt logistic regression model and outputs its prediction (see \code{\link{predict.glm}}).
}
\examples{
# Simulation of a discretized logit model
set.seed(1)
x = matrix(runif(300), nrow = 100, ncol = 3)
cuts = seq(0,1,length.out= 4)
xd = apply(x,2, function(col) as.numeric(cut(col,cuts)))
theta = t(matrix(c(0,0,0,2,2,2,-2,-2,-2),ncol=3,nrow=3))
log_odd = rowSums(t(sapply(seq_along(xd[,1]), function(row_id) sapply(seq_along(xd[row_id,]),
function(element) theta[xd[row_id,element],element]))))
y = rbinom(100,1,1/(1+exp(-log_odd)))

sem_disc <- glmdisc(x,y,iter=50,m_start=4,test=FALSE,validation=FALSE,criterion="aic")
predict(sem_disc, data.frame(x))
}
\concept{test discretization predict prediction}
