% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restrictions.R
\docType{data}
\name{parameter_restriction}
\alias{parameter_restriction}
\alias{avail_restrictions}
\alias{brn}
\alias{brn_diagSig}
\alias{brn_fixedSig}
\alias{dbrn}
\alias{dbrn_diagSig}
\alias{dbrn_fixedSig}
\alias{dou_diagH}
\alias{dou_diagH_diagSig}
\alias{dou_diagH_fixedSig}
\alias{dou_diagH_fixedtheta}
\alias{dou_diagH_fixedtheta_diagSig}
\alias{dou_diagH_fixedtheta_fixedSig}
\alias{dou_diagSig}
\alias{dou_fixedH}
\alias{dou_fixedH_diagSig}
\alias{dou_fixedH_fixedSig}
\alias{dou_fixedH_fixedtheta}
\alias{dou_fixedH_fixedtheta_diagSig}
\alias{dou_fixedSig}
\alias{dou_fixedtheta}
\alias{dou_fixedtheta_diagSig}
\alias{dou_fixedtheta_fixedSig}
\alias{dou_logdiagH}
\alias{dou_logdiagH_diagSig}
\alias{dou_logdiagH_fixedSig}
\alias{dou_logdiagH_fixedtheta}
\alias{dou_logdiagH_fixedtheta_diagSig}
\alias{dou_logdiagH_fixedtheta_fixedSig}
\alias{dou_logspdH}
\alias{dou_logspdH_diagSig}
\alias{dou_logspdH_fixedSig}
\alias{dou_logspdH_fixedtheta}
\alias{dou_logspdH_fixedtheta_diagSig}
\alias{dou_logspdH_fixedtheta_fixedSig}
\alias{dou_spdH}
\alias{dou_spdH_diagSig}
\alias{dou_spdH_fixedSig}
\alias{dou_spdH_fixedtheta}
\alias{dou_spdH_fixedtheta_diagSig}
\alias{dou_spdH_fixedtheta_fixedSig}
\alias{dou_symH}
\alias{dou_symH_diagSig}
\alias{dou_symH_fixedSig}
\alias{dou_symH_fixedtheta}
\alias{dou_symH_fixedtheta_diagSig}
\alias{dou_symH_fixedtheta_fixedSig}
\alias{hbrn}
\alias{hbrn_diagSig}
\alias{hbrn_fixedSig}
\alias{hou_diagH}
\alias{hou_diagH_diagSig}
\alias{hou_diagH_fixedSig}
\alias{hou_diagH_fixedtheta}
\alias{hou_diagH_fixedtheta_diagSig}
\alias{hou_diagH_fixedtheta_fixedSig}
\alias{hou_diagSig}
\alias{hou_fixedH}
\alias{hou_fixedH_diagSig}
\alias{hou_fixedH_fixedSig}
\alias{hou_fixedH_fixedtheta}
\alias{hou_fixedH_fixedtheta_diagSig}
\alias{hou_fixedSig}
\alias{hou_fixedtheta}
\alias{hou_fixedtheta_diagSig}
\alias{hou_fixedtheta_fixedSig}
\alias{hou_logdiagH}
\alias{hou_logdiagH_diagSig}
\alias{hou_logdiagH_fixedSig}
\alias{hou_logdiagH_fixedtheta}
\alias{hou_logdiagH_fixedtheta_diagSig}
\alias{hou_logdiagH_fixedtheta_fixedSig}
\alias{hou_logspdH}
\alias{hou_logspdH_diagSig}
\alias{hou_logspdH_fixedSig}
\alias{hou_logspdH_fixedtheta}
\alias{hou_logspdH_fixedtheta_diagSig}
\alias{hou_logspdH_fixedtheta_fixedSig}
\alias{hou_spdH}
\alias{hou_spdH_diagSig}
\alias{hou_spdH_fixedSig}
\alias{hou_spdH_fixedtheta}
\alias{hou_spdH_fixedtheta_diagSig}
\alias{hou_spdH_fixedtheta_fixedSig}
\alias{hou_symH}
\alias{hou_symH_diagSig}
\alias{hou_symH_fixedSig}
\alias{hou_symH_fixedtheta}
\alias{hou_symH_fixedtheta_diagSig}
\alias{hou_symH_fixedtheta_fixedSig}
\alias{nparams_brn}
\alias{nparams_brn_diagSig}
\alias{nparams_brn_fixedSig}
\alias{nparams_ou_diagH}
\alias{nparams_ou_diagH_diagSig}
\alias{nparams_ou_diagH_fixedSig}
\alias{nparams_ou_diagH_fixedtheta}
\alias{nparams_ou_diagH_fixedtheta_diagSig}
\alias{nparams_ou_diagH_fixedtheta_fixedSig}
\alias{nparams_ou_diagSig}
\alias{nparams_ou_fixedH}
\alias{nparams_ou_fixedH_diagSig}
\alias{nparams_ou_fixedH_fixedSig}
\alias{nparams_ou_fixedH_fixedtheta}
\alias{nparams_ou_fixedH_fixedtheta_diagSig}
\alias{nparams_ou_fixedSig}
\alias{nparams_ou_fixedtheta}
\alias{nparams_ou_fixedtheta_diagSig}
\alias{nparams_ou_fixedtheta_fixedSig}
\alias{nparams_ou_logdiagH}
\alias{nparams_ou_logdiagH_diagSig}
\alias{nparams_ou_logdiagH_fixedSig}
\alias{nparams_ou_logdiagH_fixedtheta}
\alias{nparams_ou_logdiagH_fixedtheta_diagSig}
\alias{nparams_ou_logdiagH_fixedtheta_fixedSig}
\alias{nparams_ou_logspdH}
\alias{nparams_ou_logspdH_diagSig}
\alias{nparams_ou_logspdH_fixedSig}
\alias{nparams_ou_logspdH_fixedtheta}
\alias{nparams_ou_logspdH_fixedtheta_diagSig}
\alias{nparams_ou_logspdH_fixedtheta_fixedSig}
\alias{nparams_ou_spdH}
\alias{nparams_ou_spdH_diagSig}
\alias{nparams_ou_spdH_fixedSig}
\alias{nparams_ou_spdH_fixedtheta}
\alias{nparams_ou_spdH_fixedtheta_diagSig}
\alias{nparams_ou_spdH_fixedtheta_fixedSig}
\alias{nparams_ou_symH}
\alias{nparams_ou_symH_diagSig}
\alias{nparams_ou_symH_fixedSig}
\alias{nparams_ou_symH_fixedtheta}
\alias{nparams_ou_symH_fixedtheta_diagSig}
\alias{nparams_ou_symH_fixedtheta_fixedSig}
\alias{ou_diagH}
\alias{ou_diagH_diagSig}
\alias{ou_diagH_fixedSig}
\alias{ou_diagH_fixedtheta}
\alias{ou_diagH_fixedtheta_diagSig}
\alias{ou_diagH_fixedtheta_fixedSig}
\alias{ou_diagSig}
\alias{ou_fixedH}
\alias{ou_fixedH_diagSig}
\alias{ou_fixedH_fixedSig}
\alias{ou_fixedH_fixedtheta}
\alias{ou_fixedH_fixedtheta_diagSig}
\alias{ou_fixedSig}
\alias{ou_fixedtheta}
\alias{ou_fixedtheta_diagSig}
\alias{ou_fixedtheta_fixedSig}
\alias{ou_logdiagH}
\alias{ou_logdiagH_diagSig}
\alias{ou_logdiagH_fixedSig}
\alias{ou_logdiagH_fixedtheta}
\alias{ou_logdiagH_fixedtheta_diagSig}
\alias{ou_logdiagH_fixedtheta_fixedSig}
\alias{ou_logspdH}
\alias{ou_logspdH_diagSig}
\alias{ou_logspdH_fixedSig}
\alias{ou_logspdH_fixedtheta}
\alias{ou_logspdH_fixedtheta_diagSig}
\alias{ou_logspdH_fixedtheta_fixedSig}
\alias{ou_spdH}
\alias{ou_spdH_diagSig}
\alias{ou_spdH_fixedSig}
\alias{ou_spdH_fixedtheta}
\alias{ou_spdH_fixedtheta_diagSig}
\alias{ou_spdH_fixedtheta_fixedSig}
\alias{ou_symH}
\alias{ou_symH_diagSig}
\alias{ou_symH_fixedSig}
\alias{ou_symH_fixedtheta}
\alias{ou_symH_fixedtheta_diagSig}
\alias{ou_symH_fixedtheta_fixedSig}
\title{Restrict the parameters space of OU and Brownian motion models.}
\format{
An object of class \code{list} of length 4.
}
\usage{
avail_restrictions

brn_diagSig(parfn)

ou_logdiagH(parfn)

dou_logdiagH(jacfn)

hou_logdiagH(hessfn)

ou_logdiagH_diagSig(parfn)

ou_logspdH_fixedtheta(parfn, theta)

ou_spdH_fixedSig(parfn, Sig)

ou_fixedH_diagSig(parfn, H)

dou_logdiagH_diagSig(jacfn)

dou_logspdH_fixedtheta(jacfn, theta)

dou_spdH_fixedSig(jacfn, Sig)

dou_fixedH_diagSig(jacfn, H)

hou_logdiagH_diagSig(hessfn)

hou_logspdH_fixedtheta(hessfn, jacfn, theta)

hou_spdH_fixedSig(hessfn, jacfn, Sig)

hou_spdH_fixedtheta_fixedSig(hessfn, jacfn, theta, Sig)

hou_fixedH_diagSig(hessfn, H)

nparams_ou_logdiagH(k)

nparams_brn(k)

nparams_ou_spdH_fixedSig(k)
}
\arguments{
\item{parfn}{A function that maps from the user-parametrisation to the underlying Gaussian parameters.
Each of them returns a vector of concatenated \eqn{(\Phi, w, V')}, where \eqn{V'} is the lower triangular
part of \eqn{V}, and accepts four arguments: a vector of parameters whose length is specified
by the \code{pardims} argument to the \code{glinv_gauss} function, the branch length leading to the currently processing node, 
a vector of factors with three levels indicating which dimensions are missing or lost in the mother of
the current node, and a vector of factors with the same three levels indicating missingness of the current
node.}

\item{jacfn}{A function that accepts the same arguments as \code{parfn} and returns the Jacobian
of \code{parfn}.}

\item{hessfn}{A function that accepts the same arguments as \code{parfns} and returns a list of three 3D arrays,
named \code{Phi}, \code{w}, \code{V} respectively inside the list. \code{((hessfn)(...))$Phi[m,i,j]}
contains the cross second-order partial derivative of \eqn{\Phi_m} (here we treat the matrix
\eqn{\Phi} as a column-major-flattened vector) with respect to the \eqn{i}-th and\eqn{j}-th parameters
in the joint \eqn{(H,\theta,\Sigma_x')} vector, and
\code{((hessfn)(...))$w[m,i,j]} and \code{((hessfn)(...))$V[m,i,j]}
analogously contains second-order derivative with respect to \eqn{w_m} and \eqn{V'_m}.}

\item{H}{A numerical vector containing the (flattened) fixed parameter \eqn{H}.}

\item{theta}{A numerical vector containing the (flattened) fixed parameter \eqn{theta}.}

\item{Sig}{A numerical vector containing the (flattened) fixed parameter \eqn{\Sigma_x'}.}

\item{k}{An integer. The total number of dimensions of the multivariate traits.}
}
\description{
\code{ou_diagH}, \code{ou_diagH_fixedtheta_diagSig}, etc., restricts the OU model's
parameters. For example, \code{ou_diagH} restricts the drift \eqn{H} to diagonal matrix,
and \code{ou_diagH_fixedtheta_diagSig} further restricts theta to be a constant and
\eqn{\Sigma_x'} to be diagonal. A Brownian motion model can be made by these restriction.
}
\details{
\subsection{How reparametrisation and restriction works}{

In the simplest form, without any restriction or reparametrisation, the user typically
needs to pass \code{oupar}, \code{oujac}, \code{ouhess}, all of which are simply
functions which maps from the OU parameters \eqn{(H,\theta,\Sigma_x')} to the Gaussian
paramters \eqn{(\Phi_i,w_i,V'_i)} for each node. For example:
\preformatted{
        mod.full = glinv(tree, x0, my_data,
                         parfns  = oupar,
                         pardims = nparams_ou(k),
                         parjacs = oujac,
                         parhess = ouhess)
}
If one would like to restrict \eqn{H} to only positively definite diagonal matrices,
then the call should become
\preformatted{
        mod.pddiag = glinv(tree, x0, my_data,
                           parfns  = ou_logdiagH(oupar),
                           pardims = nparams_ou_logdiagH(k),
                           parjacs = dou_logdiagH(oujac),
                           parhess = hou_logdiagH(ouhess))
}
Note that there is a naming convention that \code{ou_*} should be applied to `oupar`,
\code{dou_*} to `oujac`, and \code{hou_*} to `ouhess`. \code{d} stands for `derivative'
and \code{h} stands for `Hessian'.

In the above call, ou_logdiagH(oupar) accepts the \code{oupar} function as argument
and returns a new function. This new function behaves the same way as oupar itself,
except that it expects its first argument (which is the model parameters) to be of
lower dimension, only consisting of \eqn{(h,\theta,\Sigma_x')} where \eqn{h} is the
diagonal vector of \eqn{H}. The following example should be illustrative:
\preformatted{
        f = ou_logdiagH(oupar)
        par.full = list(H     = matrix(c(3,0,0,2),2,2), # diagonal matrix
                        theta = c(4,5),
                        sig_x = c(1,0.1,1))
        par.restricted = list(H     = log(diag(par.full$H)),
                              theta = par.full$theta,
                              sig_x = par.full$sig_x)
        print(all.equal(f(unlist(par.restricted),1,NULL,NULL),
                        oupar(unlist(par.full),1,NULL,NULL)))
        # [1] TRUE
}
}

\subsection{Pre-defined restrictions}{
The following table summarises all the pre-defined \code{ou_*} functions. See \code{\link{oupar}}
for precise meaning of the \eqn{(H,\theta,\Sigma_x')} mentioned below.
\tabular{ll}{
  \strong{R function}   \tab \strong{Parameter Format after Restriction}\cr
  \code{brn*}           \tab \eqn{\Sigma_x'}. The Brownian motion. \eqn{H} and \eqn{\theta} are zero, thus missing.\cr
  \code{*_diagH_*}      \tab \eqn{(h,\theta,\Sigma_x')}, with \eqn{h=diag(H)}, and H is a diagonal matrix\cr
  \code{*_logdiagH_*}   \tab \eqn{(log(h),\theta,\Sigma_x')}, with \eqn{h=diag(H)}, and H is a diagonal matrix\cr
  \code{*_symH_*}       \tab \eqn{(L,\theta,\Sigma_x')}, with \eqn{L} being lower-triangular part of the symmetric matrix \eqn{H}\cr
  \code{*_spdH_*}       \tab \eqn{(L,\theta,\Sigma_x')}, with \eqn{L} being Cholesky factor of the S.P.D. matrix \eqn{H}\cr
  \code{*_logspdH_*}    \tab \eqn{(L',\theta,\Sigma_x')} where \eqn{L'} equals \eqn{L}, except that on the diagonals \eqn{L'_i} = \eqn{log L_i}\cr
  \code{*_fixedH_*}     \tab \eqn{(\theta,\Sigma_x')}. \eqn{H} is constant, hence missing\cr
  \code{*_fixedtheta_*} \tab \eqn{(H,\Sigma_x')}. \eqn{\theta} is constant, hence missing\cr
  \code{*_fixedSig_*}   \tab \eqn{(H,\theta)}. \eqn{\Sigma_x} is constant, hence missing\cr
  \code{*_diagSig_*}    \tab \eqn{(H,\theta,s)} where \eqn{s=diag(\Sigma_x'}, with \eqn{\Sigma_x'} being a diagonal matrix.
}
By Cholesky factor, we mean the only the non-zero part of the lower-triangular Cholesky factor. Restricting \eqn{\Sigma_x'} to a diagonal matrix
means that \eqn{\Sigma_x} is also diagonal; and the variance of the Brownian motion is \eqn{log(diag(\Sigma_x'))}. In other words, the diagonal
restriction is placed on \eqn{\Sigma_x'}, not \eqn{\Sigma_x}.
}
\subsection{Finding a list of these restriction functions}{
One can use \code{print(avail_restrictions)} to see a list of all of these restriction function names.
}
\subsection{Calling these restriction functions}{
 All \code{*ou_*} or \code{*brn*} functions accepts the same arguemnts as \code{ou_logdiagH},
 \code{dou_logdiagH}, \code{hou_logdiagH}, \code{nparams_ou_logdiagH} as shown in the Usage
 and Arguments section, except that:
 \enumerate{
    \item If the reparametrisation contains any Cholesky decomposition (in other words, the function name
          contains \code{spd} or \code{logspd}) then in the Hessian-level reparameterisation function
          (named \code{hou_*}) an extra argument \code{jacfn} is required.
    \item If the reparametrisation contains any fixed parameters, extra arguments \code{H}, \code{theta},
          or \code{Sig} are required, depending what is fixed.
 }
 For example, in the Usage section, \code{ou_logspdH_fixedtheta} takes an extra argument \code{theta} because
 of (2), and \code{hou_spdH_fixedSig} takes extra argument two extra arguments because of both (1) and (2) are
 true.
}
}
\keyword{datasets}
