% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glinvci.R
\name{set_tips}
\alias{set_tips}
\alias{set_tips.glinv_gauss}
\alias{set_tips.glinv}
\title{Set trait values at the tip for a \code{glinv_gauss} model.}
\usage{
set_tips(mod, X)

\method{set_tips}{glinv_gauss}(mod, X)

\method{set_tips}{glinv}(mod, X)
}
\arguments{
\item{mod}{A \code{glinv_gauss} or \code{glinv} object.}

\item{X}{A matrix of trait values, in which \code{X[p,n]} stores the p-th dimension
of the multivariate trait of the n-th tip of the phylogeny.}
}
\value{
No return value, called for side effects.
}
\description{
If a \code{glinv_gauss} or \code{glinv} object were initalised with \code{X=NULL}, methods like
\code{lik} will not work because it lacks actual data. In this case, the user
should set the trait values using this method. Any existing trait values
were replaced after calling this.
}
\details{
This method alters an underlying C structure, therefore has a mutable-object
semantic (See example).
}
\examples{
tr = ape::rtree(10)
model = glinv_gauss(tr, x0=c(0,0))  # The `X` argument is implicitly NULL
traits = matrix(rnorm(20), 2, 10)
set_tips(model, traits)
# Now lik(model, ...) should work

}
