% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBeta.R
\name{beta.control}
\alias{beta.control}
\title{Control arguments for \eqn{\beta} update algorithm}
\usage{
beta.control(eps = 1e-10, maxiter = 1, maxhalf = 10)
}
\arguments{
\item{eps}{Convergence threshold. The update has converged when the relative
change in log-likelihood between iterations is less than \code{eps}.
Only applies if \code{maxiter>1}.}

\item{maxiter}{Maximum number of iterations allowed.}

\item{maxhalf}{Maximum number of half steps allowed per iteration if
log-likelihood does not improve.}
}
\value{
Object of S3 class "betaControl", which is a list of control arguments.
}
\description{
This function returns control arguments for the \eqn{\beta} update algorithm.
Each argument has a default value, which will be used unless a different
value is provided by the user.
}
