% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_package.R
\docType{package}
\name{gittargets-package}
\alias{gittargets-package}
\title{targets: Dynamic Function-Oriented Make-Like Declarative Pipelines for R}
\description{
Pipelines with the \code{targets} R package skip  steps that
are up to already date. Although this behavior reduces the runtime
of subsequent runs, it comes at the cost of overwriting previous
results. So if the pipeline source code is under version control,
and if you revert to a previous commit or branch,
the data will no longer be up to date with the code you
just checked out. Ordinarily, you would need to rerun the
pipeline in order to recover the targets you had before.
However, \code{gittargets} preserves historical output,
creating version control snapshots of data store.
Each data snapshot remembers the contemporaneous Git commit
of the pipeline source code, so you can recover the right
data when you navigate the Git history. In other words,
\code{gittargets} makes it possible to switch commits or branches
without invalidating the pipeline. You can simply check out
the up-to-date targets from the past instead of taking the
time to recompute them from scratch.
}
\concept{help}
