% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_info_files.R
\name{create_vignette_last_modif}
\alias{create_vignette_last_modif}
\alias{update_vignette_last_modif}
\title{Creates and updates a vignette in the 'vignette/' directory of a package with last modification time of tracked files}
\usage{
create_vignette_last_modif(
  repo = ".",
  path = "R",
  recursive = TRUE,
  untracked = TRUE
)

update_vignette_last_modif(
  repo = ".",
  path = "R",
  recursive = TRUE,
  untracked = TRUE
)
}
\arguments{
\item{repo}{git repository}

\item{path}{Default to R folder. Use "" for the complete directory}

\item{recursive}{Logical. Should the listing recurse into directories?}

\item{untracked}{Logical. Should the not tracked files be included?}
}
\value{
No return value, called for side effect.
Creates and updates the content of the "modification_files.Rmd" vignette
}
\description{
Creates and updates a vignette in the 'vignette/' directory of a package with last modification time of tracked files
}
\examples{

# Creates vignette
repo <- fake_repo(as.package = TRUE)
if (rmarkdown::pandoc_available("1.12.3")) {
  create_vignette_last_modif(repo, path = "R")
}
# update vignette
repo <- fake_repo(as.package = TRUE)
if (rmarkdown::pandoc_available("1.12.3")) {
  update_vignette_last_modif(repo, path = "R")
  rmarkdown::render(file.path(repo, "vignettes", "modification_files.Rmd"))
}
}
